/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.compute.strategy.PrioritizeCredentialsFromTemplate;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.domain.Location;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.GoogleComputeEngineService;
import org.jclouds.googlecomputeengine.compute.GoogleComputeEngineServiceAdapter;
import org.jclouds.googlecomputeengine.compute.functions.BuildInstanceMetadata;
import org.jclouds.googlecomputeengine.compute.functions.GoogleComputeEngineImageToImage;
import org.jclouds.googlecomputeengine.compute.functions.InstanceToNodeMetadata;
import org.jclouds.googlecomputeengine.compute.functions.MachineTypeToHardware;
import org.jclouds.googlecomputeengine.compute.functions.OrphanedGroupsFromDeadNodes;
import org.jclouds.googlecomputeengine.compute.functions.ZoneToLocation;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.compute.predicates.AllNodesInGroupTerminated;
import org.jclouds.googlecomputeengine.compute.strategy.UseNodeCredentialsButOverrideFromTemplate;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.MachineType;
import org.jclouds.googlecomputeengine.domain.Zone;

public class GoogleComputeEngineServiceContextModule
extends ComputeServiceAdapterContextModule<Instance, MachineType, Image, Zone> {
    @VisibleForTesting
    public static final Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put((Object)Instance.Status.PROVISIONING, (Object)NodeMetadata.Status.PENDING).put((Object)Instance.Status.STAGING, (Object)NodeMetadata.Status.PENDING).put((Object)Instance.Status.RUNNING, (Object)NodeMetadata.Status.RUNNING).put((Object)Instance.Status.STOPPING, (Object)NodeMetadata.Status.PENDING).put((Object)Instance.Status.STOPPED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Instance.Status.TERMINATED, (Object)NodeMetadata.Status.TERMINATED).build();

    protected void configure() {
        super.configure();
        this.bind(ComputeService.class).to(GoogleComputeEngineService.class);
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<Instance, MachineType, Image, Zone>>(){}).to(GoogleComputeEngineServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Instance, NodeMetadata>>(){}).to(InstanceToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<MachineType, Hardware>>(){}).to(MachineTypeToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Image, org.jclouds.compute.domain.Image>>(){}).to(GoogleComputeEngineImageToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Zone, Location>>(){}).to(ZoneToLocation.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<TemplateOptions, ImmutableMap.Builder<String, String>>>(){}).to(BuildInstanceMetadata.class);
        this.bind(PopulateDefaultLoginCredentialsForImageStrategy.class).to(org.jclouds.googlecomputeengine.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy.class);
        this.bind(CreateNodesWithGroupEncodedIntoNameThenAddToSet.class).to(org.jclouds.googlecomputeengine.compute.strategy.CreateNodesWithGroupEncodedIntoNameThenAddToSet.class);
        this.bind(TemplateOptions.class).to(GoogleComputeEngineTemplateOptions.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Set<? extends NodeMetadata>, Set<String>>>(){}).to(OrphanedGroupsFromDeadNodes.class);
        this.bind((TypeLiteral)new TypeLiteral<Predicate<String>>(){}).to(AllNodesInGroupTerminated.class);
        this.bind(PrioritizeCredentialsFromTemplate.class).to(UseNodeCredentialsButOverrideFromTemplate.class);
        this.install((Module)new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<Instance, MachineType, Image, Zone>(){});
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<Map<URI, ? extends org.jclouds.compute.domain.Image>> provideImagesMap(final Supplier<Set<? extends org.jclouds.compute.domain.Image>> images) {
        return new Supplier<Map<URI, ? extends org.jclouds.compute.domain.Image>>(){

            public Map<URI, ? extends org.jclouds.compute.domain.Image> get() {
                return Maps.uniqueIndex((Iterable)((Iterable)images.get()), (Function)new Function<org.jclouds.compute.domain.Image, URI>(){

                    public URI apply(org.jclouds.compute.domain.Image input) {
                        return input.getUri();
                    }
                });
            }
        };
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<Map<URI, ? extends Hardware>> provideHardwaresMap(final Supplier<Set<? extends Hardware>> hardwares) {
        return new Supplier<Map<URI, ? extends Hardware>>(){

            public Map<URI, ? extends Hardware> get() {
                return Maps.uniqueIndex((Iterable)((Iterable)hardwares.get()), (Function)new Function<Hardware, URI>(){

                    public URI apply(Hardware input) {
                        return input.getUri();
                    }
                });
            }
        };
    }

    @Provides
    @Singleton
    @Memoized
    public Supplier<Map<URI, ? extends Location>> provideLocations(final GoogleComputeEngineApi api, final Function<Zone, Location> zoneToLocation, final @UserProject Supplier<String> userProject) {
        return new Supplier<Map<URI, ? extends Location>>(){

            public Map<URI, ? extends Location> get() {
                return Maps.uniqueIndex((Iterable)Iterables.transform((Iterable)api.getZoneApiForProject((String)userProject.get()).list().concat(), (Function)zoneToLocation), (Function)new Function<Location, URI>(){

                    public URI apply(Location input) {
                        return (URI)input.getMetadata().get("selfLink");
                    }
                });
            }
        };
    }

    protected Optional<ImageExtension> provideImageExtension(Injector i) {
        return Optional.absent();
    }

    @Singleton
    @Provides
    protected Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }
}

