/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.googlecomputeengine.domain.Instance;

public class InstanceToNodeMetadata
implements Function<Instance, NodeMetadata> {
    private final Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus;
    private final GroupNamingConvention nodeNamingConvention;
    private final Supplier<Map<URI, ? extends Image>> images;
    private final Supplier<Map<URI, ? extends Hardware>> hardwares;
    private final Supplier<Map<URI, ? extends Location>> locations;

    @Inject
    public InstanceToNodeMetadata(Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus, GroupNamingConvention.Factory namingConvention, @Memoized Supplier<Map<URI, ? extends Image>> images, @Memoized Supplier<Map<URI, ? extends Hardware>> hardwares, @Memoized Supplier<Map<URI, ? extends Location>> locations) {
        this.toPortableNodeStatus = toPortableNodeStatus;
        this.nodeNamingConvention = namingConvention.createWithoutPrefix();
        this.images = images;
        this.hardwares = hardwares;
        this.locations = locations;
    }

    public NodeMetadata apply(Instance input) {
        Map imagesMap = (Map)this.images.get();
        Image image = (Image)Preconditions.checkNotNull(imagesMap.get(Preconditions.checkNotNull((Object)input.getImage(), (Object)"image")), (String)"no image for %s. images: %s", (Object[])new Object[]{input.getImage(), imagesMap.values()});
        return new NodeMetadataBuilder().id(input.getName()).name(input.getName()).providerId(input.getId()).hostname(input.getName()).imageId(image.getId()).location((Location)Preconditions.checkNotNull(((Map)this.locations.get()).get(input.getZone()), (String)"location for %s", (Object[])new Object[]{input.getZone()})).hardware((Hardware)Preconditions.checkNotNull(((Map)this.hardwares.get()).get(input.getMachineType()), (String)"hardware type for %s", (Object[])new Object[]{input.getMachineType().toString()})).operatingSystem(image.getOperatingSystem()).status(this.toPortableNodeStatus.get((Object)input.getStatus())).tags(input.getTags()).uri(input.getSelfLink()).userMetadata(input.getMetadata()).group(this.nodeNamingConvention.groupInUniqueNameOrNull(input.getName())).privateAddresses(this.collectPrivateAddresses(input)).publicAddresses(this.collectPublicAddresses(input)).build();
    }

    private Set<String> collectPrivateAddresses(Instance input) {
        ImmutableSet.Builder privateAddressesBuilder = ImmutableSet.builder();
        for (Instance.NetworkInterface networkInterface : input.getNetworkInterfaces()) {
            if (!networkInterface.getNetworkIP().isPresent()) continue;
            privateAddressesBuilder.add(networkInterface.getNetworkIP().get());
        }
        return privateAddressesBuilder.build();
    }

    private Set<String> collectPublicAddresses(Instance input) {
        ImmutableSet.Builder publicAddressesBuilder = ImmutableSet.builder();
        for (Instance.NetworkInterface networkInterface : input.getNetworkInterfaces()) {
            for (Instance.NetworkInterface.AccessConfig accessConfig : networkInterface.getAccessConfigs()) {
                if (!accessConfig.getNatIP().isPresent()) continue;
                publicAddressesBuilder.add(accessConfig.getNatIP().get());
            }
        }
        return publicAddressesBuilder.build();
    }
}

