/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.googlecomputeengine.domain.MachineType;

public class MachineTypeToHardware
implements Function<MachineType, Hardware> {
    public Hardware apply(MachineType input) {
        return new HardwareBuilder().id(input.getName()).name(input.getName()).hypervisor("kvm").processor(new Processor((double)input.getGuestCpus(), 1.0)).providerId(input.getId()).ram(input.getMemoryMb()).uri(input.getSelfLink()).volumes(this.collectVolumes(input)).build();
    }

    private Iterable<Volume> collectVolumes(MachineType input) {
        ImmutableSet.Builder volumes = ImmutableSet.builder();
        for (MachineType.EphemeralDisk disk : input.getEphemeralDisks()) {
            volumes.add((Object)new VolumeImpl(null, Volume.Type.LOCAL, Float.valueOf(new Integer(disk.getDiskGb()).floatValue()), null, true, false));
        }
        return volumes.build();
    }
}

