/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.options;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.scriptbuilder.domain.Statement;

public class GoogleComputeEngineTemplateOptions
extends TemplateOptions {
    private Optional<URI> network = Optional.absent();
    private Optional<String> networkName = Optional.absent();
    private Set<Instance.ServiceAccount> serviceAccounts = Sets.newLinkedHashSet();
    private boolean enableNat = true;

    public GoogleComputeEngineTemplateOptions clone() {
        GoogleComputeEngineTemplateOptions options = new GoogleComputeEngineTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof GoogleComputeEngineTemplateOptions) {
            GoogleComputeEngineTemplateOptions eTo = (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(to));
            eTo.network((URI)this.getNetwork().orNull());
            eTo.network((String)this.getNetworkName().orNull());
            eTo.serviceAccounts(this.getServiceAccounts());
            eTo.enableNat(this.isEnableNat());
        }
    }

    public GoogleComputeEngineTemplateOptions network(String networkName) {
        this.networkName = Optional.fromNullable((Object)networkName);
        return this;
    }

    public GoogleComputeEngineTemplateOptions network(URI network) {
        this.network = Optional.fromNullable((Object)network);
        return this;
    }

    public GoogleComputeEngineTemplateOptions addServiceAccount(Instance.ServiceAccount serviceAccout) {
        this.serviceAccounts.add(serviceAccout);
        return this;
    }

    public GoogleComputeEngineTemplateOptions serviceAccounts(Set<Instance.ServiceAccount> serviceAccounts) {
        this.serviceAccounts = Sets.newLinkedHashSet(serviceAccounts);
        return this;
    }

    public GoogleComputeEngineTemplateOptions enableNat(boolean enableNat) {
        this.enableNat = enableNat;
        return this;
    }

    public GoogleComputeEngineTemplateOptions blockOnPort(int port, int seconds) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.blockOnPort(port, seconds)));
    }

    public GoogleComputeEngineTemplateOptions inboundPorts(int ... ports) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.inboundPorts(ports)));
    }

    public GoogleComputeEngineTemplateOptions authorizePublicKey(String publicKey) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.authorizePublicKey(publicKey)));
    }

    public GoogleComputeEngineTemplateOptions installPrivateKey(String privateKey) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.installPrivateKey(privateKey)));
    }

    public GoogleComputeEngineTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning)));
    }

    public GoogleComputeEngineTemplateOptions dontAuthorizePublicKey() {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.dontAuthorizePublicKey()));
    }

    public GoogleComputeEngineTemplateOptions nameTask(String name) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.nameTask(name)));
    }

    public GoogleComputeEngineTemplateOptions runAsRoot(boolean runAsRoot) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.runAsRoot(runAsRoot)));
    }

    public GoogleComputeEngineTemplateOptions runScript(Statement script) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.runScript(script)));
    }

    public GoogleComputeEngineTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials)));
    }

    public GoogleComputeEngineTemplateOptions overrideLoginPassword(String password) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.overrideLoginPassword(password)));
    }

    public GoogleComputeEngineTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey)));
    }

    public GoogleComputeEngineTemplateOptions overrideLoginUser(String loginUser) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.overrideLoginUser(loginUser)));
    }

    public GoogleComputeEngineTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo)));
    }

    public GoogleComputeEngineTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.userMetadata(userMetadata)));
    }

    public GoogleComputeEngineTemplateOptions userMetadata(String key, String value) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.userMetadata(key, value)));
    }

    public GoogleComputeEngineTemplateOptions tags(Iterable<String> tags) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.tags(tags)));
    }

    public GoogleComputeEngineTemplateOptions wrapInInitScript(boolean wrapInInitScript) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.wrapInInitScript(wrapInInitScript)));
    }

    public GoogleComputeEngineTemplateOptions runScript(String script) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.runScript(script)));
    }

    public GoogleComputeEngineTemplateOptions blockOnComplete(boolean blockOnComplete) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.blockOnComplete(blockOnComplete)));
    }

    public Set<Instance.ServiceAccount> getServiceAccounts() {
        return this.serviceAccounts;
    }

    public Optional<URI> getNetwork() {
        return this.network;
    }

    public Optional<String> getNetworkName() {
        return this.networkName;
    }

    public boolean isEnableNat() {
        return this.enableNat;
    }
}

