/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.options.FirewallOptions;
import org.jclouds.util.Predicates2;

public class CreateNodesWithGroupEncodedIntoNameThenAddToSet
extends org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    public static final String EXTERIOR_RANGE = "0.0.0.0/0";
    public static final String DEFAULT_INTERNAL_NETWORK_RANGE = "10.0.0.0/8";
    private final GoogleComputeEngineApi api;
    private final Supplier<String> userProject;
    private final Predicate<AtomicReference<Operation>> operationDonePredicate;
    private final long operationCompleteCheckInterval;
    private final long operationCompleteCheckTimeout;

    @Inject
    protected CreateNodesWithGroupEncodedIntoNameThenAddToSet(CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, GoogleComputeEngineApi api, @UserProject Supplier<String> userProject, Predicate<AtomicReference<Operation>> operationDonePredicate, @Named(value="jclouds.google-compute-engine.operation-complete-interval") Long operationCompleteCheckInterval, @Named(value="jclouds.google-compute-engine.operation-complete-timeout") Long operationCompleteCheckTimeout) {
        super(addNodeWithGroupStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"google compute api");
        this.userProject = (Supplier)Preconditions.checkNotNull(userProject, (Object)"user project name");
        this.operationCompleteCheckInterval = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckInterval, (Object)"operation completed check interval");
        this.operationCompleteCheckTimeout = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckTimeout, (Object)"operation completed check timeout");
        this.operationDonePredicate = operationDonePredicate;
    }

    public synchronized Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        String sharedResourceName = this.namingConvention.create().sharedNameForGroup(group);
        Template mutableTemplate = template.clone();
        GoogleComputeEngineTemplateOptions templateOptions = (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(mutableTemplate.getOptions()));
        assert (template.getOptions().equals((Object)templateOptions)) : "options didn't clone properly";
        Network network = this.getOrCreateNetwork(templateOptions, sharedResourceName);
        this.getOrCreateFirewall(templateOptions, network, sharedResourceName);
        templateOptions.network(network.getSelfLink());
        return super.execute(group, count, mutableTemplate, goodNodes, badNodes, customizationResponses);
    }

    private Network getOrCreateNetwork(GoogleComputeEngineTemplateOptions templateOptions, String sharedResourceName) {
        String networkName = (String)templateOptions.getNetworkName().or((Object)sharedResourceName);
        Network network = this.api.getNetworkApiForProject((String)this.userProject.get()).get(networkName);
        if (network != null) {
            return network;
        }
        if (templateOptions.getNetwork().isPresent()) {
            throw new IllegalArgumentException("requested network " + networkName + " does not exist");
        }
        AtomicReference<Operation> operation = new AtomicReference<Operation>(this.api.getNetworkApiForProject((String)this.userProject.get()).createInIPv4Range(sharedResourceName, DEFAULT_INTERNAL_NETWORK_RANGE));
        Predicates2.retry(this.operationDonePredicate, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply(operation);
        Preconditions.checkState((!operation.get().getHttpError().isPresent() ? 1 : 0) != 0, (Object)("Could not create network, operation failed" + operation));
        return (Network)Preconditions.checkNotNull((Object)this.api.getNetworkApiForProject((String)this.userProject.get()).get(sharedResourceName), (String)"no network with name %s was found", (Object[])new Object[]{sharedResourceName});
    }

    private void getOrCreateFirewall(GoogleComputeEngineTemplateOptions templateOptions, Network network, String sharedResourceName) {
        Firewall firewall = this.api.getFirewallApiForProject((String)this.userProject.get()).get(sharedResourceName);
        if (firewall != null) {
            return;
        }
        ImmutableSet.Builder rules = ImmutableSet.builder();
        Firewall.Rule.Builder tcpRule = Firewall.Rule.builder();
        tcpRule.IPProtocol(Firewall.Rule.IPProtocol.TCP);
        Firewall.Rule.Builder udpRule = Firewall.Rule.builder();
        udpRule.IPProtocol(Firewall.Rule.IPProtocol.UDP);
        int[] arr$ = templateOptions.getInboundPorts();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer port = arr$[i$];
            tcpRule.addPort(port);
            udpRule.addPort(port);
        }
        rules.add((Object)tcpRule.build());
        rules.add((Object)udpRule.build());
        FirewallOptions options = new FirewallOptions().name(sharedResourceName).network(network.getSelfLink()).sourceTags(templateOptions.getTags()).allowedRules((Set<Firewall.Rule>)rules.build()).sourceRanges((Set<String>)ImmutableSet.of((Object)DEFAULT_INTERNAL_NETWORK_RANGE, (Object)EXTERIOR_RANGE));
        AtomicReference<Operation> operation = new AtomicReference<Operation>(this.api.getFirewallApiForProject((String)this.userProject.get()).createInNetwork(sharedResourceName, network.getSelfLink(), options));
        Predicates2.retry(this.operationDonePredicate, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply(operation);
        Preconditions.checkState((!operation.get().getHttpError().isPresent() ? 1 : 0) != 0, (Object)("Could not create firewall, operation failed" + operation));
    }
}

