/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.config;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.InstanceTemplate;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.Project;
import org.jclouds.googlecomputeengine.options.FirewallOptions;
import org.jclouds.json.config.GsonModule;
import org.jclouds.oauth.v2.domain.ClaimSet;
import org.jclouds.oauth.v2.domain.Header;
import org.jclouds.oauth.v2.json.ClaimSetTypeAdapter;
import org.jclouds.oauth.v2.json.HeaderTypeAdapter;

public class GoogleComputeEngineParserModule
extends AbstractModule {
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
    }

    @Provides
    @Singleton
    public Map<Type, Object> provideCustomAdapterBindings() {
        return new ImmutableMap.Builder().put(Metadata.class, (Object)new MetadataTypeAdapter()).put(Operation.class, (Object)new OperationTypeAdapter()).put(Header.class, (Object)new HeaderTypeAdapter()).put(ClaimSet.class, (Object)new ClaimSetTypeAdapter()).put(Project.class, (Object)new ProjectTypeAdapter()).put(Instance.class, (Object)new InstanceTypeAdapter()).put(InstanceTemplate.class, (Object)new InstanceTemplateTypeAdapter()).put(FirewallOptions.class, (Object)new FirewallOptionsTypeAdapter()).put(Firewall.Rule.class, (Object)new RuleTypeAdapter()).build();
    }

    private static JsonArray buildArrayOfStrings(Set<String> strings) {
        JsonArray array = new JsonArray();
        for (String string : strings) {
            array.add((JsonElement)new JsonPrimitive(string));
        }
        return array;
    }

    private static class RuleTypeAdapter
    implements JsonDeserializer<Firewall.Rule>,
    JsonSerializer<Firewall.Rule> {
        private RuleTypeAdapter() {
        }

        public Firewall.Rule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject rule = json.getAsJsonObject();
            Firewall.Rule.Builder builder = Firewall.Rule.builder();
            builder.IPProtocol(Firewall.Rule.IPProtocol.fromValue(rule.get("IPProtocol").getAsString()));
            if (rule.get("ports") != null) {
                JsonArray ports = (JsonArray)rule.get("ports");
                for (JsonElement port : ports) {
                    String portAsString = port.getAsString();
                    if (portAsString.contains("-")) {
                        String[] split = portAsString.split("-");
                        builder.addPortRange(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
                        continue;
                    }
                    builder.addPort(Integer.parseInt(portAsString));
                }
            }
            return builder.build();
        }

        public JsonElement serialize(Firewall.Rule src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject ruleObject = new JsonObject();
            ruleObject.addProperty("IPProtocol", src.getIPProtocol().value());
            if (src.getPorts() != null && !src.getPorts().isEmpty()) {
                JsonArray ports = new JsonArray();
                for (Range range : src.getPorts().asRanges()) {
                    ports.add((JsonElement)new JsonPrimitive(range.lowerEndpoint() == range.upperEndpoint() ? range.lowerEndpoint() + "" : range.lowerEndpoint() + "-" + range.upperEndpoint()));
                }
                ruleObject.add("ports", (JsonElement)ports);
            }
            return ruleObject;
        }
    }

    @Singleton
    private static class FirewallOptionsTypeAdapter
    implements JsonSerializer<FirewallOptions> {
        private FirewallOptionsTypeAdapter() {
        }

        public JsonElement serialize(FirewallOptions src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject firewall = new JsonObject();
            if (src.getName() != null) {
                firewall.addProperty("name", src.getName());
            }
            if (src.getNetwork() != null) {
                firewall.addProperty("network", src.getNetwork().toString());
            }
            if (!src.getSourceRanges().isEmpty()) {
                firewall.add("sourceRanges", (JsonElement)GoogleComputeEngineParserModule.buildArrayOfStrings(src.getSourceRanges()));
            }
            if (!src.getSourceTags().isEmpty()) {
                firewall.add("sourceTags", (JsonElement)GoogleComputeEngineParserModule.buildArrayOfStrings(src.getSourceTags()));
            }
            if (!src.getTargetTags().isEmpty()) {
                firewall.add("targetTags", (JsonElement)GoogleComputeEngineParserModule.buildArrayOfStrings(src.getTargetTags()));
            }
            if (!src.getAllowed().isEmpty()) {
                JsonArray rules = new JsonArray();
                for (Firewall.Rule rule : src.getAllowed()) {
                    rules.add(context.serialize((Object)rule, Firewall.Rule.class));
                }
                firewall.add("allowed", (JsonElement)rules);
            }
            return firewall;
        }
    }

    @Singleton
    private static class ProjectTypeAdapter
    implements JsonDeserializer<Project> {
        private ProjectTypeAdapter() {
        }

        public Project deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Project.builder().fromProject((Project)context.deserialize(json, ProjectInternal.class)).build();
        }

        private static class ProjectInternal
        extends Project {
            @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "commonInstanceMetadata", "quotas", "externalIpAddresses"})
            private ProjectInternal(String id, Date creationTimestamp, URI selfLink, String name, String description, Metadata commonInstanceMetadata, Set<Project.Quota> quotas, Set<String> externalIpAddresses) {
                super(id, creationTimestamp, selfLink, name, description, (Map<String, String>)((Object)commonInstanceMetadata), quotas, externalIpAddresses);
            }
        }
    }

    public static class Metadata
    extends ForwardingMap<String, String> {
        private final Map<String, String> delegate;

        public Metadata(Map<String, String> delegate) {
            this.delegate = delegate;
        }

        protected Map<String, String> delegate() {
            return this.delegate;
        }
    }

    @Singleton
    private static class MetadataTypeAdapter
    implements JsonDeserializer<Metadata>,
    JsonSerializer<Metadata> {
        private MetadataTypeAdapter() {
        }

        public Metadata deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            JsonObject metadata = json.getAsJsonObject();
            JsonArray items = metadata.getAsJsonArray("items");
            if (items != null) {
                for (JsonElement element : items) {
                    JsonObject object = element.getAsJsonObject();
                    builder.put((Object)object.get("key").getAsString(), (Object)object.get("value").getAsString());
                }
            }
            return new Metadata((Map<String, String>)builder.build());
        }

        public JsonElement serialize(Metadata src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject metadataObject = new JsonObject();
            metadataObject.add("kind", (JsonElement)new JsonPrimitive("compute#metadata"));
            JsonArray items = new JsonArray();
            for (Map.Entry entry : src.entrySet()) {
                JsonObject object = new JsonObject();
                object.addProperty("key", (String)entry.getKey());
                object.addProperty("value", (String)entry.getValue());
                items.add((JsonElement)object);
            }
            metadataObject.add("items", (JsonElement)items);
            return metadataObject;
        }
    }

    @Singleton
    private static class InstanceTypeAdapter
    implements JsonDeserializer<Instance> {
        private InstanceTypeAdapter() {
        }

        public Instance deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Instance.Builder instanceBuilder = ((Instance)context.deserialize(json, InstanceInternal.class)).toBuilder();
            JsonObject object = (JsonObject)json;
            if (object.get("disks") != null) {
                JsonArray disks = (JsonArray)object.get("disks");
                for (JsonElement element : disks) {
                    JsonObject disk = (JsonObject)element;
                    if (disk.get("type").getAsString().equals("PERSISTENT")) {
                        instanceBuilder.addDisk((Instance.PersistentAttachedDisk)context.deserialize((JsonElement)disk, Instance.PersistentAttachedDisk.class));
                        continue;
                    }
                    instanceBuilder.addDisk((Instance.AttachedDisk)context.deserialize((JsonElement)disk, Instance.AttachedDisk.class));
                }
            }
            return Instance.builder().fromInstance(instanceBuilder.build()).build();
        }

        private static class InstanceInternal
        extends Instance {
            @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "tags", "image", "machineType", "status", "statusMessage", "zone", "networkInterfaces", "metadata", "serviceAccounts"})
            private InstanceInternal(String id, Date creationTimestamp, URI selfLink, String name, String description, Set<String> tags, URI image, URI machineType, Instance.Status status, String statusMessage, URI zone, Set<Instance.NetworkInterface> networkInterfaces, Metadata metadata, Set<Instance.ServiceAccount> serviceAccounts) {
                super(id, creationTimestamp, selfLink, name, description, tags, image, machineType, status, statusMessage, zone, networkInterfaces, null, (Map<String, String>)((Object)metadata), serviceAccounts);
            }
        }
    }

    @Singleton
    private static class InstanceTemplateTypeAdapter
    implements JsonSerializer<InstanceTemplate> {
        private InstanceTemplateTypeAdapter() {
        }

        public JsonElement serialize(InstanceTemplate src, Type typeOfSrc, JsonSerializationContext context) {
            InstanceTemplateInternal template = new InstanceTemplateInternal(src);
            JsonObject instance = (JsonObject)context.serialize((Object)template, InstanceTemplateInternal.class);
            JsonArray networkInterfaces = new JsonArray();
            for (InstanceTemplate.NetworkInterface networkInterface : template.getNetworkInterfaces()) {
                networkInterfaces.add(context.serialize((Object)networkInterface, InstanceTemplate.NetworkInterface.class));
            }
            instance.add("networkInterfaces", (JsonElement)networkInterfaces);
            if (src.getDisks() != null && !src.getDisks().isEmpty()) {
                JsonArray disks = new JsonArray();
                for (InstanceTemplate.PersistentDisk persistentDisk : src.getDisks()) {
                    JsonObject disk = (JsonObject)context.serialize((Object)persistentDisk, InstanceTemplate.PersistentDisk.class);
                    disk.addProperty("type", "PERSISTENT");
                    disks.add((JsonElement)disk);
                }
                instance.add("disks", (JsonElement)disks);
            }
            if (src.getMetadata() != null && !src.getMetadata().isEmpty()) {
                JsonObject metadata = (JsonObject)context.serialize((Object)new Metadata(src.getMetadata()));
                instance.add("metadata", (JsonElement)metadata);
                return instance;
            }
            return instance;
        }

        private static class InstanceTemplateInternal
        extends InstanceTemplate {
            private InstanceTemplateInternal(InstanceTemplate template) {
                super(template.getMachineType());
                this.name(template.getName());
                this.description(template.getDescription());
                this.zone(template.getZone());
                this.image(template.getImage());
                this.tags(template.getTags());
                this.serviceAccounts(template.getServiceAccounts());
                this.networkInterfaces(template.getNetworkInterfaces());
            }
        }
    }

    @Singleton
    private static class OperationTypeAdapter
    implements JsonDeserializer<Operation> {
        private OperationTypeAdapter() {
        }

        public Operation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray array;
            Operation.Builder operationBuilder = ((Operation)context.deserialize(json, OperationInternal.class)).toBuilder();
            JsonObject error = json.getAsJsonObject().getAsJsonObject("error");
            if (error != null && (array = error.getAsJsonArray("errors")) != null) {
                for (JsonElement element : array) {
                    operationBuilder.addError((Operation.Error)context.deserialize(element, Operation.Error.class));
                }
            }
            return operationBuilder.build();
        }

        private static class OperationInternal
        extends Operation {
            @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "targetLink", "targetId", "clientOperationId", "status", "statusMessage", "user", "progress", "insertTime", "startTime", "endTime", "httpErrorStatusCode", "httpErrorMessage", "operationType"})
            private OperationInternal(String id, Date creationTimestamp, URI selfLink, String name, String description, URI targetLink, String targetId, String clientOperationId, Operation.Status status, String statusMessage, String user, int progress, Date insertTime, Date startTime, Date endTime, int httpErrorStatusCode, String httpErrorMessage, String operationType) {
                super(id, creationTimestamp, selfLink, name, description, targetLink, targetId, clientOperationId, status, statusMessage, user, progress, insertTime, startTime, endTime, httpErrorStatusCode, httpErrorMessage, operationType, null);
            }
        }
    }
}

