/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.GoogleComputeEngineAsyncApi;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.features.DiskApi;
import org.jclouds.googlecomputeengine.features.DiskAsyncApi;
import org.jclouds.googlecomputeengine.features.FirewallApi;
import org.jclouds.googlecomputeengine.features.FirewallAsyncApi;
import org.jclouds.googlecomputeengine.features.ImageApi;
import org.jclouds.googlecomputeengine.features.ImageAsyncApi;
import org.jclouds.googlecomputeengine.features.InstanceApi;
import org.jclouds.googlecomputeengine.features.InstanceAsyncApi;
import org.jclouds.googlecomputeengine.features.KernelApi;
import org.jclouds.googlecomputeengine.features.KernelAsyncApi;
import org.jclouds.googlecomputeengine.features.MachineTypeApi;
import org.jclouds.googlecomputeengine.features.MachineTypeAsyncApi;
import org.jclouds.googlecomputeengine.features.NetworkApi;
import org.jclouds.googlecomputeengine.features.NetworkAsyncApi;
import org.jclouds.googlecomputeengine.features.OperationApi;
import org.jclouds.googlecomputeengine.features.OperationAsyncApi;
import org.jclouds.googlecomputeengine.features.ProjectApi;
import org.jclouds.googlecomputeengine.features.ProjectAsyncApi;
import org.jclouds.googlecomputeengine.features.ZoneApi;
import org.jclouds.googlecomputeengine.features.ZoneAsyncApi;
import org.jclouds.googlecomputeengine.handlers.GoogleComputeEngineErrorHandler;
import org.jclouds.googlecomputeengine.predicates.OperationDonePredicate;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.Uris;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.Provider;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
public class GoogleComputeEngineRestClientModule
extends RestClientModule<GoogleComputeEngineApi, GoogleComputeEngineAsyncApi> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(DiskApi.class, DiskAsyncApi.class).put(FirewallApi.class, FirewallAsyncApi.class).put(ImageApi.class, ImageAsyncApi.class).put(InstanceApi.class, InstanceAsyncApi.class).put(KernelApi.class, KernelAsyncApi.class).put(MachineTypeApi.class, MachineTypeAsyncApi.class).put(NetworkApi.class, NetworkAsyncApi.class).put(OperationApi.class, OperationAsyncApi.class).put(ProjectApi.class, ProjectAsyncApi.class).put(ZoneApi.class, ZoneAsyncApi.class).build();

    public GoogleComputeEngineRestClientModule() {
        super(DELEGATE_MAP);
    }

    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Predicate<AtomicReference<Operation>>>(){}).to(OperationDonePredicate.class);
        super.configure();
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(GoogleComputeEngineErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(GoogleComputeEngineErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(GoogleComputeEngineErrorHandler.class);
    }

    @Provides
    @Singleton
    @UserProject
    public Supplier<String> supplyProject(@Provider Supplier<Credentials> creds) {
        return Suppliers.compose((Function)new Function<Credentials, String>(){

            public String apply(Credentials in) {
                Preconditions.checkState((in.identity.indexOf("@") != 1 ? 1 : 0) != 0, (Object)"identity should be in project_id@developer.gserviceaccount.com format");
                return (String)Iterables.get((Iterable)Splitter.on((String)"@").split((CharSequence)in.identity), (int)0);
            }
        }, creds);
    }

    @Provides
    @Singleton
    @Named(value="machineTypes")
    public Function<String, URI> provideMachineTypeNameToURIFunction(final @Provider Supplier<URI> endpoint, final @UserProject Supplier<String> userProject) {
        return new Function<String, URI>(){

            public URI apply(String input) {
                return Uris.uriBuilder((URI)((URI)endpoint.get())).appendPath("/projects/").appendPath((String)userProject.get()).appendPath("/machineTypes/").appendPath(input).build();
            }
        };
    }

    @Provides
    @Singleton
    @Named(value="networks")
    public Function<String, URI> provideNetworkNameToURIFunction(final @Provider Supplier<URI> endpoint, final @UserProject Supplier<String> userProject) {
        return new Function<String, URI>(){

            public URI apply(String input) {
                return Uris.uriBuilder((URI)((URI)endpoint.get())).appendPath("/projects/").appendPath((String)userProject.get()).appendPath("/networks/").appendPath(input).build();
            }
        };
    }

    @Provides
    @Singleton
    @Named(value="zones")
    public Function<String, URI> provideZoneNameToURIFunction(final @Provider Supplier<URI> endpoint, final @UserProject Supplier<String> userProject) {
        return new Function<String, URI>(){

            public URI apply(String input) {
                return Uris.uriBuilder((URI)((URI)endpoint.get())).appendPath("/projects/").appendPath((String)userProject.get()).appendPath("/zones/").appendPath(input).build();
            }
        };
    }
}

