/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import org.jclouds.googlecomputeengine.domain.Resource;

@Beta
public final class Disk
extends Resource {
    private final Integer sizeGb;
    private final URI zone;
    private final String status;

    @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "sizeGb", "zone", "status"})
    private Disk(String id, Date creationTimestamp, URI selfLink, String name, String description, Integer sizeGb, URI zone, String status) {
        super(Resource.Kind.DISK, id, creationTimestamp, selfLink, name, description);
        this.sizeGb = (Integer)Preconditions.checkNotNull((Object)sizeGb, (String)"sizeGb of %s", (Object[])new Object[]{name});
        this.zone = (URI)Preconditions.checkNotNull((Object)zone, (String)"zone of %s", (Object[])new Object[]{name});
        this.status = (String)Preconditions.checkNotNull((Object)status, (String)"status of %s", (Object[])new Object[]{name});
    }

    public int getSizeGb() {
        return this.sizeGb;
    }

    public URI getZone() {
        return this.zone;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().omitNullValues().add("sizeGb", (Object)this.sizeGb).add("zone", (Object)this.zone).add("status", (Object)this.status);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromDisk(this);
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private Integer sizeGb;
        private URI zone;
        private String status;

        public Builder sizeGb(Integer sizeGb) {
            this.sizeGb = sizeGb;
            return this;
        }

        public Builder zone(URI zone) {
            this.zone = zone;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Disk build() {
            return new Disk(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.sizeGb, this.zone, this.status);
        }

        public Builder fromDisk(Disk in) {
            return ((Builder)super.fromResource(in)).sizeGb(in.getSizeGb()).zone(in.getZone()).status(in.getStatus());
        }
    }
}

