/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import org.jclouds.googlecomputeengine.domain.Resource;

@Beta
public final class Image
extends Resource {
    private final String sourceType;
    private final Optional<URI> preferredKernel;
    private final RawDisk rawDisk;

    @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "sourceType", "preferredKernel", "rawDisk"})
    protected Image(String id, Date creationTimestamp, URI selfLink, String name, String description, String sourceType, URI preferredKernel, RawDisk rawDisk) {
        super(Resource.Kind.IMAGE, id, creationTimestamp, selfLink, name, description);
        this.sourceType = (String)Preconditions.checkNotNull((Object)sourceType, (String)"sourceType of %s", (Object[])new Object[]{name});
        this.preferredKernel = Optional.fromNullable((Object)preferredKernel);
        this.rawDisk = (RawDisk)Preconditions.checkNotNull((Object)rawDisk, (String)"rawDisk of %s", (Object[])new Object[]{name});
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public Optional<URI> getPreferredKernel() {
        return this.preferredKernel;
    }

    public RawDisk getRawDisk() {
        return this.rawDisk;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().omitNullValues().add("sourceType", (Object)this.sourceType).add("preferredKernel", this.preferredKernel.orNull()).add("rawDisk", (Object)this.rawDisk);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromImage(this);
    }

    public static class RawDisk {
        private final String source;
        private final String containerType;
        private final Optional<String> sha1Checksum;

        @ConstructorProperties(value={"source", "containerType", "sha1Checksum"})
        private RawDisk(String source, String containerType, String sha1Checksum) {
            this.source = (String)Preconditions.checkNotNull((Object)source, (Object)"source");
            this.containerType = (String)Preconditions.checkNotNull((Object)containerType, (Object)"containerType");
            this.sha1Checksum = Optional.fromNullable((Object)sha1Checksum);
        }

        public String getSource() {
            return this.source;
        }

        public String getContainerType() {
            return this.containerType;
        }

        public Optional<String> getSha1Checksum() {
            return this.sha1Checksum;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.source, this.containerType, this.sha1Checksum});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RawDisk that = (RawDisk)RawDisk.class.cast(obj);
            return Objects.equal((Object)this.source, (Object)that.source) && Objects.equal((Object)this.containerType, (Object)that.containerType) && Objects.equal(this.sha1Checksum, that.sha1Checksum);
        }

        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("source", (Object)this.source).add("containerType", (Object)this.containerType).add("sha1Checksum", this.sha1Checksum.orNull());
        }

        public String toString() {
            return this.string().toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return RawDisk.builder().fromImageRawDisk(this);
        }

        public static class Builder {
            private String source;
            private String containerType;
            private String sha1Checksum;

            public Builder source(String source) {
                this.source = (String)Preconditions.checkNotNull((Object)source);
                return this;
            }

            public Builder containerType(String containerType) {
                this.containerType = (String)Preconditions.checkNotNull((Object)containerType);
                return this;
            }

            public Builder sha1Checksum(String sha1Checksum) {
                this.sha1Checksum = sha1Checksum;
                return this;
            }

            public RawDisk build() {
                return new RawDisk(this.source, this.containerType, this.sha1Checksum);
            }

            public Builder fromImageRawDisk(RawDisk rawDisk) {
                return new Builder().source(rawDisk.getSource()).containerType(rawDisk.getContainerType()).sha1Checksum((String)rawDisk.getSha1Checksum().orNull());
            }
        }
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private String sourceType;
        private URI preferredKernel;
        private RawDisk rawDisk;

        public Builder sourceType(String sourceType) {
            this.sourceType = (String)Preconditions.checkNotNull((Object)sourceType, (Object)"sourceType");
            return this;
        }

        public Builder preferredKernel(URI preferredKernel) {
            this.preferredKernel = preferredKernel;
            return this;
        }

        public Builder rawDisk(RawDisk rawDisk) {
            this.rawDisk = (RawDisk)Preconditions.checkNotNull((Object)rawDisk);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Image build() {
            return new Image(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.sourceType, this.preferredKernel, this.rawDisk);
        }

        public Builder fromImage(Image in) {
            return ((Builder)super.fromResource(in)).sourceType(in.getSourceType()).preferredKernel((URI)in.getPreferredKernel().orNull()).rawDisk(in.getRawDisk());
        }
    }
}

