/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jclouds.googlecomputeengine.domain.Instance;

public class InstanceTemplate {
    protected String name;
    protected String description;
    protected URI machineType;
    protected URI zone;
    protected URI image;
    protected Set<String> tags = Sets.newLinkedHashSet();
    protected Set<Instance.ServiceAccount> serviceAccounts = Sets.newLinkedHashSet();
    protected transient Set<PersistentDisk> disks = Sets.newLinkedHashSet();
    protected transient Set<NetworkInterface> networkInterfaces = Sets.newLinkedHashSet();
    protected transient Map<String, String> metadata = Maps.newLinkedHashMap();
    protected transient String machineTypeName;
    protected transient String zoneName;

    protected InstanceTemplate(URI machineType) {
        this.machineType = (URI)Preconditions.checkNotNull((Object)machineType, (Object)"machineType");
    }

    protected InstanceTemplate(String machineTypeName) {
        this.machineTypeName = (String)Preconditions.checkNotNull((Object)machineTypeName, (Object)"machineTypeName");
    }

    public InstanceTemplate name(String name) {
        this.name = name;
        return this;
    }

    public InstanceTemplate description(String description) {
        this.description = description;
        return this;
    }

    public InstanceTemplate image(URI image) {
        this.image = image;
        return this;
    }

    public InstanceTemplate machineType(URI machineType) {
        this.machineType = machineType;
        return this;
    }

    public InstanceTemplate machineType(String machineTypeName) {
        this.machineTypeName = machineTypeName;
        return this;
    }

    public InstanceTemplate zone(String zoneName) {
        this.zoneName = zoneName;
        return this;
    }

    public InstanceTemplate zone(URI zone) {
        this.zone = zone;
        return this;
    }

    public InstanceTemplate addTag(String tag) {
        this.tags.add((String)Preconditions.checkNotNull((Object)tag, (Object)"tag"));
        return this;
    }

    public InstanceTemplate tags(Set<String> tags) {
        this.tags = Sets.newLinkedHashSet();
        this.tags.addAll((Collection)Preconditions.checkNotNull(tags, (Object)"tags"));
        return this;
    }

    public InstanceTemplate addDisk(PersistentDisk.Mode mode, URI source) {
        this.disks.add(new PersistentDisk(mode, source, null, null));
        return this;
    }

    public InstanceTemplate addDisk(PersistentDisk.Mode mode, URI source, String deviceName, Boolean deleteOnTerminate) {
        this.disks.add(new PersistentDisk(mode, source, deviceName, deleteOnTerminate));
        return this;
    }

    public InstanceTemplate disks(Set<PersistentDisk> disks) {
        this.disks = Sets.newLinkedHashSet();
        this.disks.addAll((Collection)Preconditions.checkNotNull(disks, (Object)"disks"));
        return this;
    }

    public InstanceTemplate addNetworkInterface(URI network) {
        this.networkInterfaces.add(new NetworkInterface((URI)Preconditions.checkNotNull((Object)network, (Object)"network"), null, null));
        return this;
    }

    public InstanceTemplate addNetworkInterface(URI network, Instance.NetworkInterface.AccessConfig.Type type) {
        this.networkInterfaces.add(new NetworkInterface((URI)Preconditions.checkNotNull((Object)network, (Object)"network"), null, (Set<Instance.NetworkInterface.AccessConfig>)ImmutableSet.of((Object)Instance.NetworkInterface.AccessConfig.builder().type(type).build())));
        return this;
    }

    public InstanceTemplate addNetworkInterface(NetworkInterface networkInterface) {
        this.networkInterfaces.add(networkInterface);
        return this;
    }

    public InstanceTemplate networkInterfaces(Set<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = Sets.newLinkedHashSet(networkInterfaces);
        return this;
    }

    public InstanceTemplate addMetadata(String key, String value) {
        this.metadata.put((String)Preconditions.checkNotNull((Object)key, (Object)"key"), (String)Preconditions.checkNotNull((Object)value, (String)"value of %", (Object[])new Object[]{key}));
        return this;
    }

    public InstanceTemplate metadata(Map<String, String> metadata) {
        this.metadata = Maps.newLinkedHashMap();
        this.metadata.putAll((Map)Preconditions.checkNotNull(metadata, (Object)"metadata"));
        return this;
    }

    public InstanceTemplate addServiceAccount(Instance.ServiceAccount serviceAccount) {
        this.serviceAccounts.add((Instance.ServiceAccount)Preconditions.checkNotNull((Object)serviceAccount, (Object)"serviceAccount"));
        return this;
    }

    public InstanceTemplate serviceAccounts(Set<Instance.ServiceAccount> serviceAccounts) {
        this.serviceAccounts = Sets.newLinkedHashSet();
        this.serviceAccounts.addAll((Collection)Preconditions.checkNotNull(serviceAccounts, (Object)"serviceAccounts"));
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<PersistentDisk> getDisks() {
        return this.disks;
    }

    public URI getImage() {
        return this.image;
    }

    public URI getMachineType() {
        return this.machineType;
    }

    public String getMachineTypeName() {
        return this.machineTypeName;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Set<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public Set<Instance.ServiceAccount> getServiceAccounts() {
        return this.serviceAccounts;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public String getName() {
        return this.name;
    }

    public URI getZone() {
        return this.zone;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static InstanceTemplate fromInstanceTemplate(InstanceTemplate instanceTemplate) {
        return Builder.fromInstanceTemplate(instanceTemplate);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof InstanceTemplate) {
            InstanceTemplate other = (InstanceTemplate)InstanceTemplate.class.cast(object);
            return Objects.equal((Object)this.description, (Object)other.description) && Objects.equal(this.tags, other.tags) && Objects.equal((Object)this.image, (Object)other.image) && Objects.equal(this.disks, other.disks) && Objects.equal(this.networkInterfaces, other.networkInterfaces) && Objects.equal(this.metadata, other.metadata) && Objects.equal(this.serviceAccounts, other.serviceAccounts);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.description, this.tags, this.image, this.disks, this.networkInterfaces, this.metadata, this.serviceAccounts});
    }

    protected Objects.ToStringHelper string() {
        Objects.ToStringHelper toString = Objects.toStringHelper((String)"").omitNullValues();
        toString.add("description", (Object)this.description);
        if (this.tags.size() > 0) {
            toString.add("tags", this.tags);
        }
        if (this.disks.size() > 0) {
            toString.add("disks", this.disks);
        }
        if (this.metadata.size() > 0) {
            toString.add("metadata", this.metadata);
        }
        if (this.serviceAccounts.size() > 0) {
            toString.add("serviceAccounts", this.serviceAccounts);
        }
        toString.add("image", (Object)this.image);
        toString.add("networkInterfaces", this.networkInterfaces);
        return toString;
    }

    public String toString() {
        return this.string().toString();
    }

    public static class NetworkInterface {
        private final URI network;
        private final String networkIP;
        private final Set<Instance.NetworkInterface.AccessConfig> accessConfigs;

        public NetworkInterface(URI network, String networkIP, Set<Instance.NetworkInterface.AccessConfig> accessConfigs) {
            this.networkIP = networkIP;
            this.network = network;
            this.accessConfigs = accessConfigs != null ? accessConfigs : ImmutableSet.of();
        }

        public Set<Instance.NetworkInterface.AccessConfig> getAccessConfigs() {
            return this.accessConfigs;
        }

        public URI getNetwork() {
            return this.network;
        }

        public String getNetworkIP() {
            return this.networkIP;
        }
    }

    public static class PersistentDisk {
        private final Mode mode;
        private final URI source;
        private final Boolean deleteOnTerminate;
        private final String deviceName;

        public PersistentDisk(Mode mode, URI source, String deviceName, Boolean deleteOnTerminate) {
            this.mode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode"));
            this.source = (URI)Preconditions.checkNotNull((Object)source, (Object)"source");
            this.deviceName = deviceName;
            this.deleteOnTerminate = deleteOnTerminate;
        }

        public Mode getMode() {
            return this.mode;
        }

        public URI getSource() {
            return this.source;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public boolean isDeleteOnTerminate() {
            return this.deleteOnTerminate;
        }

        public static enum Mode {
            READ_WRITE,
            READ_ONLY;

        }
    }

    public static class Builder {
        public InstanceTemplate forMachineType(URI machineType) {
            return new InstanceTemplate(machineType);
        }

        public InstanceTemplate forMachineType(String machineTypeName) {
            return new InstanceTemplate(machineTypeName);
        }

        public static InstanceTemplate fromInstanceTemplate(InstanceTemplate instanceTemplate) {
            return InstanceTemplate.builder().forMachineType(instanceTemplate.getMachineType()).networkInterfaces(instanceTemplate.getNetworkInterfaces()).name(instanceTemplate.getName()).description(instanceTemplate.getDescription()).zone(instanceTemplate.getZone()).image(instanceTemplate.getImage()).tags(instanceTemplate.getTags()).disks(instanceTemplate.getDisks()).metadata(instanceTemplate.getMetadata()).serviceAccounts(instanceTemplate.getServiceAccounts());
        }
    }
}

