/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jclouds.googlecomputeengine.domain.Resource;

@Beta
public final class MachineType
extends Resource {
    private final Integer guestCpus;
    private final Integer memoryMb;
    private final Integer imageSpaceGb;
    private final List<EphemeralDisk> ephemeralDisks;
    private final Integer maximumPersistentDisks;
    private final Long maximumPersistentDisksSizeGb;
    private final Set<String> availableZone;

    @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "guestCpus", "memoryMb", "imageSpaceGb", "ephemeralDisks", "maximumPersistentDisks", "maximumPersistentDisksSizeGb", "availableZone"})
    private MachineType(String id, Date creationTimestamp, URI selfLink, String name, String description, int guestCpus, int memoryMb, int imageSpaceGb, List<EphemeralDisk> ephemeralDisks, int maximumPersistentDisks, long maximumPersistentDisksSizeGb, Set<String> availableZone) {
        super(Resource.Kind.MACHINE_TYPE, id, creationTimestamp, selfLink, name, description);
        this.guestCpus = (Integer)Preconditions.checkNotNull((Object)guestCpus, (String)"guestCpus of %s", (Object[])new Object[]{name});
        this.memoryMb = (Integer)Preconditions.checkNotNull((Object)memoryMb, (String)"memoryMb of %s", (Object[])new Object[]{name});
        this.imageSpaceGb = (Integer)Preconditions.checkNotNull((Object)imageSpaceGb, (String)"imageSpaceGb of %s", (Object[])new Object[]{name});
        this.ephemeralDisks = ephemeralDisks == null ? ImmutableList.of() : ephemeralDisks;
        this.maximumPersistentDisks = (Integer)Preconditions.checkNotNull((Object)maximumPersistentDisks, (String)"maximumPersistentDisks of %s", (Object[])new Object[]{name});
        this.maximumPersistentDisksSizeGb = maximumPersistentDisksSizeGb;
        this.availableZone = availableZone == null ? ImmutableSet.of() : availableZone;
    }

    public int getGuestCpus() {
        return this.guestCpus;
    }

    public int getMemoryMb() {
        return this.memoryMb;
    }

    public int getImageSpaceGb() {
        return this.imageSpaceGb;
    }

    public List<EphemeralDisk> getEphemeralDisks() {
        return this.ephemeralDisks;
    }

    public int getMaximumPersistentDisks() {
        return this.maximumPersistentDisks;
    }

    public long getMaximumPersistentDisksSizeGb() {
        return this.maximumPersistentDisksSizeGb;
    }

    public Set<String> getAvailableZone() {
        return this.availableZone;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("guestCpus", (Object)this.guestCpus).add("memoryMb", (Object)this.memoryMb).add("imageSpaceGb", (Object)this.imageSpaceGb).add("ephemeralDisks", this.ephemeralDisks).add("maximumPersistentDisks", (Object)this.maximumPersistentDisks).add("maximumPersistentDisksSizeGb", (Object)this.maximumPersistentDisksSizeGb).add("availableZone", this.availableZone);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromMachineType(this);
    }

    public static final class EphemeralDisk {
        private final int diskGb;

        @ConstructorProperties(value={"diskGb"})
        private EphemeralDisk(int diskGb) {
            this.diskGb = diskGb;
        }

        public int getDiskGb() {
            return this.diskGb;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.diskGb});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EphemeralDisk that = (EphemeralDisk)EphemeralDisk.class.cast(obj);
            return Objects.equal((Object)this.diskGb, (Object)that.diskGb);
        }

        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).add("diskGb", this.diskGb);
        }

        public String toString() {
            return this.string().toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return EphemeralDisk.builder().fromEphemeralDisk(this);
        }

        public static class Builder {
            private int diskGb;

            public Builder diskGb(int diskGb) {
                this.diskGb = diskGb;
                return this;
            }

            public EphemeralDisk build() {
                return new EphemeralDisk(this.diskGb);
            }

            public Builder fromEphemeralDisk(EphemeralDisk in) {
                return new Builder().diskGb(in.getDiskGb());
            }
        }
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private Integer guestCpus;
        private Integer memoryMb;
        private Integer imageSpaceGb;
        private ImmutableList.Builder<EphemeralDisk> ephemeralDisks = ImmutableList.builder();
        private Integer maximumPersistentDisks;
        private Long maximumPersistentDisksSizeGb;
        private ImmutableSet.Builder<String> availableZone = ImmutableSet.builder();

        public Builder guestCpus(int guesCpus) {
            this.guestCpus = guesCpus;
            return this;
        }

        public Builder memoryMb(int memoryMb) {
            this.memoryMb = memoryMb;
            return this;
        }

        public Builder imageSpaceGb(int imageSpaceGb) {
            this.imageSpaceGb = imageSpaceGb;
            return this;
        }

        public Builder addEphemeralDisk(int diskGb) {
            this.ephemeralDisks.add((Object)EphemeralDisk.builder().diskGb(diskGb).build());
            return this;
        }

        public Builder ephemeralDisks(List<EphemeralDisk> ephemeralDisks) {
            this.ephemeralDisks.addAll(ephemeralDisks);
            return this;
        }

        public Builder maximumPersistentDisks(int maximumPersistentDisks) {
            this.maximumPersistentDisks = maximumPersistentDisks;
            return this;
        }

        public Builder maximumPersistentDisksSizeGb(long maximumPersistentDisksSizeGb) {
            this.maximumPersistentDisksSizeGb = maximumPersistentDisksSizeGb;
            return this;
        }

        public Builder addAvailableZone(String availableZone) {
            this.availableZone.add((Object)availableZone);
            return this;
        }

        public Builder availableZones(Set<String> availableZone) {
            this.availableZone.addAll(availableZone);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MachineType build() {
            return new MachineType(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.guestCpus, this.memoryMb, this.imageSpaceGb, (List)this.ephemeralDisks.build(), this.maximumPersistentDisks, this.maximumPersistentDisksSizeGb, (Set)this.availableZone.build());
        }

        public Builder fromMachineType(MachineType in) {
            return ((Builder)super.fromResource(in)).memoryMb(in.getMemoryMb()).imageSpaceGb(in.getImageSpaceGb()).ephemeralDisks(in.getEphemeralDisks()).maximumPersistentDisks(in.getMaximumPersistentDisks()).maximumPersistentDisksSizeGb(in.getMaximumPersistentDisksSizeGb()).availableZones(in.getAvailableZone());
        }
    }
}

