/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.googlecomputeengine.domain.Resource;
import org.jclouds.javax.annotation.Nullable;

@Beta
public class Project
extends Resource {
    private final Map<String, String> commonInstanceMetadata;
    private final Set<Quota> quotas;
    private final Set<String> externalIpAddresses;

    protected Project(String id, Date creationTimestamp, URI selfLink, String name, String description, Map<String, String> commonInstanceMetadata, Set<Quota> quotas, Set<String> externalIpAddresses) {
        super(Resource.Kind.PROJECT, id, creationTimestamp, selfLink, name, description);
        this.commonInstanceMetadata = commonInstanceMetadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(commonInstanceMetadata);
        this.quotas = quotas == null ? ImmutableSet.of() : ImmutableSet.copyOf(quotas);
        this.externalIpAddresses = externalIpAddresses == null ? ImmutableSet.of() : ImmutableSet.copyOf(externalIpAddresses);
    }

    public Map<String, String> getCommonInstanceMetadata() {
        return this.commonInstanceMetadata;
    }

    public Set<Quota> getQuotas() {
        return this.quotas;
    }

    @Nullable
    public Set<String> getExternalIpAddresses() {
        return this.externalIpAddresses;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("commonInstanceMetadata", this.commonInstanceMetadata).add("quotas", this.quotas).add("externalIpAddresses", this.externalIpAddresses);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromProject(this);
    }

    public static final class Quota {
        private String metric;
        private double usage;
        private double limit;

        @ConstructorProperties(value={"metric", "usage", "limit"})
        protected Quota(String metric, Double usage, Double limit) {
            this.metric = (String)Preconditions.checkNotNull((Object)metric, (Object)"metric");
            this.usage = (Double)Preconditions.checkNotNull((Object)usage, (Object)"usage");
            this.limit = (Double)Preconditions.checkNotNull((Object)limit, (Object)"limit");
        }

        public String getMetric() {
            return this.metric;
        }

        public Double getUsage() {
            return this.usage;
        }

        public Double getLimit() {
            return this.limit;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.metric});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Quota that = (Quota)Quota.class.cast(obj);
            return Objects.equal((Object)this.metric, (Object)that.metric);
        }

        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("metric", (Object)this.metric).add("usage", this.usage).add("limit", this.limit);
        }

        public String toString() {
            return this.string().toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return Quota.builder().fromQuota(this);
        }

        public static class Builder {
            private String metric;
            private Double usage;
            private Double limit;

            public Builder metric(String metric) {
                this.metric = (String)Preconditions.checkNotNull((Object)metric, (Object)"metric");
                return this;
            }

            public Builder usage(Double usage) {
                this.usage = usage;
                return this;
            }

            public Builder limit(Double limit) {
                this.limit = limit;
                return this;
            }

            public Quota build() {
                return new Quota(this.metric, this.usage, this.limit);
            }

            public Builder fromQuota(Quota quota) {
                return new Builder().metric(quota.getMetric()).usage(quota.getUsage()).limit(quota.getLimit());
            }
        }
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private ImmutableMap.Builder<String, String> commonInstanceMetadata = ImmutableMap.builder();
        private ImmutableSet.Builder<Quota> quotas = ImmutableSet.builder();
        private ImmutableSet.Builder<String> externalIpAddresses = ImmutableSet.builder();

        public Builder addCommonInstanceMetadata(String key, String value) {
            this.commonInstanceMetadata.put((Object)key, (Object)value);
            return this;
        }

        public Builder commonInstanceMetadata(Map<String, String> commonInstanceMetadata) {
            this.commonInstanceMetadata.putAll((Map)Preconditions.checkNotNull(commonInstanceMetadata, (Object)"commonInstanceMetadata"));
            return this;
        }

        public Builder addQuota(String metric, double usage, double limit) {
            this.quotas.add((Object)Quota.builder().metric(metric).usage(usage).limit(limit).build());
            return this;
        }

        public Builder quotas(Set<Quota> quotas) {
            this.quotas.addAll((Iterable)Preconditions.checkNotNull(quotas));
            return this;
        }

        public Builder addExternalIpAddress(String externalIpAddress) {
            this.externalIpAddresses.add(Preconditions.checkNotNull((Object)externalIpAddress, (Object)"externalIpAddress"));
            return this;
        }

        public Builder externalIpAddresses(Set<String> externalIpAddresses) {
            this.externalIpAddresses.addAll((Iterable)Preconditions.checkNotNull(externalIpAddresses, (Object)"externalIpAddresses"));
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Project build() {
            return new Project(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, (Map<String, String>)this.commonInstanceMetadata.build(), (Set<Quota>)this.quotas.build(), (Set<String>)this.externalIpAddresses.build());
        }

        public Builder fromProject(Project in) {
            return ((Builder)super.fromResource(in)).commonInstanceMetadata(in.getCommonInstanceMetadata()).quotas(in.getQuotas()).externalIpAddresses(in.getExternalIpAddresses());
        }
    }
}

