/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.googlecomputeengine.domain.Disk;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.functions.internal.ParseDisks;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticator;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticator.class})
public interface DiskAsyncApi {
    @Named(value="Disks:get")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/disks/{disk}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Disk> get(@PathParam(value="disk") String var1);

    @Named(value="Disks:insert")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @MapBinder(value=BindToJsonPayload.class)
    public ListenableFuture<Operation> createInZone(@PayloadParam(value="name") String var1, @PayloadParam(value="sizeGb") int var2, @PayloadParam(value="zone") URI var3);

    @Named(value="Disks:delete")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/disks/{disk}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Operation> delete(@PathParam(value="disk") String var1);

    @Named(value="Disks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseDisks.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListenableFuture<ListPage<Disk>> listFirstPage();

    @Named(value="Disks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseDisks.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListenableFuture<ListPage<Disk>> listAtMarker(@QueryParam(value="pageToken") @Nullable String var1);

    @Named(value="Disks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseDisks.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListenableFuture<ListPage<Disk>> listAtMarker(@QueryParam(value="pageToken") @Nullable String var1, ListOptions var2);

    @Named(value="Disks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseDisks.class)
    @Transform(value=ParseDisks.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<Disk>> list();

    @Named(value="Disks:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/disks")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseDisks.class)
    @Transform(value=ParseDisks.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<Disk>> list(ListOptions var1);
}

