/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.InstanceTemplate;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.functions.internal.ParseInstances;
import org.jclouds.googlecomputeengine.handlers.InstanceBinder;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticator;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticator.class})
public interface InstanceAsyncApi {
    @Named(value="Instances:get")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/instances/{instance}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Instance> get(@PathParam(value="instance") String var1);

    @Named(value="Instances:insert")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/instances")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @MapBinder(value=InstanceBinder.class)
    public ListenableFuture<Operation> createInZone(@PayloadParam(value="name") String var1, @PayloadParam(value="template") InstanceTemplate var2, @PayloadParam(value="zone") String var3);

    @Named(value="Instances:delete")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/instances/{instance}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Operation> delete(@PathParam(value="instance") String var1);

    @Named(value="Instances:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/instances")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseInstances.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListenableFuture<ListPage<Instance>> listFirstPage();

    @Named(value="Instances:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/instances")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseInstances.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListenableFuture<ListPage<Instance>> listAtMarker(@Nullable String var1);

    @Named(value="Instances:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/instances")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseInstances.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListenableFuture<ListPage<Instance>> listAtMarker(@Nullable String var1, ListOptions var2);

    @Named(value="Instances:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/instances")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseInstances.class)
    @Transform(value=ParseInstances.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<Instance>> list();

    @Named(value="Instances:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/instances")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseInstances.class)
    @Transform(value=ParseInstances.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<Instance>> list(ListOptions var1);

    @Named(value="Instances:addAccessConfig")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/instances/{instance}/addAccessConfig")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    public ListenableFuture<Operation> addAccessConfigToNic(@PathParam(value="instance") String var1, @BinderParam(value=BindToJsonPayload.class) Instance.NetworkInterface.AccessConfig var2, @QueryParam(value="network_interface") String var3);

    @Named(value="Instances:deleteAccessConfig")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/instances/{instance}/deleteAccessConfig")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Operation> deleteAccessConfigFromNic(@PathParam(value="instance") String var1, @QueryParam(value="access_config") String var2, @QueryParam(value="network_interface") String var3);

    @Named(value="Instances:serialPort")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/instances/{instance}/serialPort")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Instance.SerialPortOutput> getSerialPortOutput(@PathParam(value="instance") String var1);
}

