/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.functions.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.functions.internal.BaseToPagedIterable;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;

public class ParseInstances
extends ParseJson<ListPage<Instance>> {
    @Inject
    public ParseInstances(Json json) {
        super(json, (TypeLiteral)new TypeLiteral<ListPage<Instance>>(){});
    }

    public static class ToPagedIterable
    extends BaseToPagedIterable<Instance, ToPagedIterable> {
        private final GoogleComputeEngineApi api;

        @Inject
        protected ToPagedIterable(GoogleComputeEngineApi api) {
            this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        @Override
        protected Function<Object, IterableWithMarker<Instance>> fetchNextPage(final String projectName, final ListOptions options) {
            return new Function<Object, IterableWithMarker<Instance>>(){

                public IterableWithMarker<Instance> apply(Object input) {
                    return ToPagedIterable.this.api.getInstanceApiForProject(projectName).listAtMarker(input.toString(), options);
                }
            };
        }
    }
}

