/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.functions.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.MachineType;
import org.jclouds.googlecomputeengine.functions.internal.BaseToPagedIterable;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;

public class ParseMachineTypes
extends ParseJson<ListPage<MachineType>> {
    @Inject
    public ParseMachineTypes(Json json) {
        super(json, (TypeLiteral)new TypeLiteral<ListPage<MachineType>>(){});
    }

    public static class ToPagedIterable
    extends BaseToPagedIterable<MachineType, ToPagedIterable> {
        private final GoogleComputeEngineApi api;

        @Inject
        protected ToPagedIterable(GoogleComputeEngineApi api) {
            this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        @Override
        protected Function<Object, IterableWithMarker<MachineType>> fetchNextPage(final String projectName, final ListOptions options) {
            return new Function<Object, IterableWithMarker<MachineType>>(){

                public IterableWithMarker<MachineType> apply(Object input) {
                    return ToPagedIterable.this.api.getMachineTypeApiForProject(projectName).listAtMarker(input.toString(), options);
                }
            };
        }
    }
}

