/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.options;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.googlecomputeengine.domain.Firewall;

public class FirewallOptions {
    private String name;
    private URI network;
    private ImmutableSet.Builder<String> sourceRanges = ImmutableSet.builder();
    private ImmutableSet.Builder<String> sourceTags = ImmutableSet.builder();
    private ImmutableSet.Builder<String> targetTags = ImmutableSet.builder();
    private ImmutableSet.Builder<Firewall.Rule> allowed = ImmutableSet.builder();

    public Set<Firewall.Rule> getAllowed() {
        return this.allowed.build();
    }

    public FirewallOptions addAllowedRule(Firewall.Rule allowedRule) {
        this.allowed.add((Object)allowedRule);
        return this;
    }

    public FirewallOptions allowedRules(Set<Firewall.Rule> allowedRules) {
        this.allowed = ImmutableSet.builder();
        this.allowed.addAll(allowedRules);
        return this;
    }

    public FirewallOptions name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public FirewallOptions network(URI network) {
        this.network = network;
        return this;
    }

    public URI getNetwork() {
        return this.network;
    }

    public Set<String> getSourceRanges() {
        return this.sourceRanges.build();
    }

    public FirewallOptions addSourceRange(String sourceRange) {
        this.sourceRanges.add((Object)sourceRange);
        return this;
    }

    public FirewallOptions sourceRanges(Set<String> sourceRanges) {
        this.sourceRanges = ImmutableSet.builder();
        this.sourceRanges.addAll(sourceRanges);
        return this;
    }

    public Set<String> getSourceTags() {
        return this.sourceTags.build();
    }

    public FirewallOptions addSourceTag(String sourceTag) {
        this.sourceTags.add((Object)sourceTag);
        return this;
    }

    public FirewallOptions sourceTags(Set<String> sourceTags) {
        this.sourceTags = ImmutableSet.builder();
        return this;
    }

    public Set<String> getTargetTags() {
        return this.targetTags.build();
    }

    public FirewallOptions addTargetTag(String targetTag) {
        this.targetTags.add((Object)targetTag);
        return this;
    }

    public FirewallOptions targetTags(Set<String> targetTags) {
        this.targetTags = ImmutableSet.builder();
        this.targetTags.addAll(targetTags);
        return this;
    }
}

