/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Operation;

public class OperationDonePredicate
implements Predicate<AtomicReference<Operation>> {
    private final GoogleComputeEngineApi api;
    private final Supplier<String> project;

    @Inject
    OperationDonePredicate(GoogleComputeEngineApi api, @UserProject Supplier<String> project) {
        this.api = api;
        this.project = project;
    }

    public boolean apply(AtomicReference<Operation> input) {
        Preconditions.checkNotNull(input, (Object)"input");
        Operation current = this.api.getOperationApiForProject((String)this.project.get()).get(input.get().getName());
        switch (current.getStatus()) {
            case DONE: {
                input.set(current);
                return true;
            }
        }
        return false;
    }
}

