/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.handlers;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.opsource.servers.handlers.OpSourceServersErrorHandler;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class OpSourceServersErrorHandlerTest {
    @Test
    public void test401MakesAuthorizationException() {
        this.assertCodeMakes("GET", URI.create("https://api.opsourcecloud.net/oec/0.9/foo"), 401, "", "Unauthorized", AuthorizationException.class);
    }

    @Test
    public void test404MakesResourceNotFoundException() {
        this.assertCodeMakes("GET", URI.create("https://api.opsourcecloud.net/oec/0.9/foo"), 404, "", "Not Found", ResourceNotFoundException.class);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String content, Class<? extends Exception> expected) {
        this.assertCodeMakes(method, uri, statusCode, message, "text/xml", content, expected);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, Class<? extends Exception> expected) {
        OpSourceServersErrorHandler function = (OpSourceServersErrorHandler)Guice.createInjector((Module[])new Module[0]).getInstance(OpSourceServersErrorHandler.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = new HttpRequest(method, uri);
        HttpResponse response = new HttpResponse(statusCode, message, (Payload)Payloads.newInputStreamPayload((InputStream)Strings2.toInputStream((String)content)));
        response.getPayload().getContentMetadata().setContentType(contentType);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(OpSourceServersErrorHandlerTest.classEq(expected));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }

    public static Exception classEq(final Class<? extends Exception> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("classEq(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in;
            }
        });
        return null;
    }
}

