/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.config;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Scopes;
import java.util.Map;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.implicit.OnlyLocationOrFirstZone;
import org.jclouds.opsource.servers.OpSourceServersApi;
import org.jclouds.opsource.servers.OpSourceServersAsyncApi;
import org.jclouds.opsource.servers.features.AccountApi;
import org.jclouds.opsource.servers.features.AccountAsyncApi;
import org.jclouds.opsource.servers.features.ServerApi;
import org.jclouds.opsource.servers.features.ServerAsyncApi;
import org.jclouds.opsource.servers.features.ServerImageApi;
import org.jclouds.opsource.servers.features.ServerImageAsyncApi;
import org.jclouds.opsource.servers.handlers.OpSourceServersErrorHandler;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
public class OpSourceServersRestClientModule
extends RestClientModule<OpSourceServersApi, OpSourceServersAsyncApi> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(AccountApi.class, AccountAsyncApi.class).put(ServerImageApi.class, ServerImageAsyncApi.class).put(ServerApi.class, ServerAsyncApi.class).build();

    public OpSourceServersRestClientModule() {
        super(DELEGATE_MAP);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(OpSourceServersErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(OpSourceServersErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(OpSourceServersErrorHandler.class);
    }

    protected void installLocations() {
        super.installLocations();
        this.bind(ImplicitLocationSupplier.class).to(OnlyLocationOrFirstZone.class).in(Scopes.SINGLETON);
    }
}

