/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.domain;

import com.google.common.base.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Account", namespace="http://oec.api.opsource.net/schemas/directory")
public class Account {
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/directory")
    protected String orgId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromAccount(this);
    }

    private Account() {
    }

    private Account(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account that = (Account)Account.class.cast(o);
        return Objects.equal((Object)this.orgId, (Object)that.orgId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.orgId});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("orgId", (Object)this.orgId).toString();
    }

    public static class Builder {
        private String orgId;

        public Builder orgId(String orgId) {
            this.orgId = orgId;
            return this;
        }

        public Account build() {
            return new Account(this.orgId);
        }

        public Builder fromAccount(Account in) {
            return this.orgId(in.getOrgId());
        }
    }
}

