/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.domain;

import com.google.common.base.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(namespace="http://oec.api.opsource.net/schemas/datacenter", name="datacenterWithLimits")
public class DataCenter {
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/datacenter", name="location")
    private String location;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/datacenter", name="displayName")
    private String displayName;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/datacenter", name="city")
    private String city;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/datacenter", name="state")
    private String state;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/datacenter", name="country")
    private String country;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/datacenter", name="vpnUrl")
    private String vpnUrl;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/datacenter", name="isDefault")
    private boolean isDefault;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/datacenter", name="maxCpu")
    private long maxCpu;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/datacenter", name="maxRamMb")
    private long maxRamMb;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromDataCenter(this);
    }

    private DataCenter() {
    }

    private DataCenter(String location, String displayName, String city, String state, String country, String vpnUrl, boolean isDefault, long maxCpu, long maxRamMb) {
        this.location = location;
        this.displayName = displayName;
        this.city = city;
        this.state = state;
        this.country = country;
        this.vpnUrl = vpnUrl;
        this.isDefault = isDefault;
        this.maxCpu = maxCpu;
        this.maxRamMb = maxRamMb;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVpnUrl() {
        return this.vpnUrl;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public long getMaxCpu() {
        return this.maxCpu;
    }

    public long getMaxRamMb() {
        return this.maxRamMb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataCenter that = (DataCenter)DataCenter.class.cast(o);
        return Objects.equal((Object)this.location, (Object)that.location);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.location});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("location", (Object)this.location).add("displayName", (Object)this.displayName).add("city", (Object)this.city).add("state", (Object)this.state).add("country", (Object)this.country).add("vpnUrl", (Object)this.vpnUrl).add("isDefault", this.isDefault).add("maxCpu", this.maxCpu).add("maxRamMb", this.maxRamMb).toString();
    }

    public static class Builder {
        private String location;
        private String displayName;
        private String city;
        private String state;
        private String country;
        private String vpnUrl;
        private boolean isDefault;
        private int maxCpu;
        private long maxRamMb;

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder vpnUrl(String vpnUrl) {
            this.vpnUrl = vpnUrl;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Builder maxCpu(int maxCpu) {
            this.maxCpu = maxCpu;
            return this;
        }

        public Builder maxRamMb(long maxRamMb) {
            this.maxRamMb = maxRamMb;
            return this;
        }

        public DataCenter build() {
            return new DataCenter(this.location, this.displayName, this.city, this.state, this.country, this.vpnUrl, this.isDefault, this.maxCpu, this.maxRamMb);
        }

        public Builder fromDataCenter(DataCenter in) {
            return new Builder().location(this.location).displayName(this.displayName).city(this.city).state(this.state).country(this.country).vpnUrl(this.vpnUrl).isDefault(this.isDefault).maxCpu(this.maxCpu).maxRamMb(this.maxRamMb);
        }
    }
}

