/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.opsource.servers.domain.DataCenter;

@XmlRootElement(namespace="http://oec.api.opsource.net/schemas/datacenter", name="DatacentersWithLimits")
public class DataCentersList {
    @XmlElement(name="datacenterWithLimits", namespace="http://oec.api.opsource.net/schemas/datacenter")
    private Set<DataCenter> dataCenters = Sets.newLinkedHashSet();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder();
    }

    private DataCentersList() {
    }

    private DataCentersList(Set<DataCenter> dataCenters) {
        this.dataCenters = ImmutableSet.copyOf(dataCenters);
    }

    public Set<DataCenter> getDataCenters() {
        return this.dataCenters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataCentersList that = (DataCentersList)DataCentersList.class.cast(o);
        return super.equals(that) && Objects.equal(this.dataCenters, that.dataCenters);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dataCenters});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("dataCenters", this.dataCenters).toString();
    }

    public static class Builder {
        Set<DataCenter> dataCenters = Sets.newLinkedHashSet();

        public Builder dataCenters(Set<DataCenter> dataCenters) {
            this.dataCenters = Sets.newLinkedHashSet((Iterable)((Iterable)Preconditions.checkNotNull(dataCenters, (Object)"dataCenters")));
            return this;
        }

        public Builder dataCenter(DataCenter dataCenter) {
            this.dataCenters.add((DataCenter)Preconditions.checkNotNull((Object)dataCenter, (Object)"dataCenter"));
            return this;
        }

        public DataCentersList build() {
            return new DataCentersList(this.dataCenters);
        }
    }
}

