/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.domain;

import com.google.common.base.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.opsource.servers.domain.BaseServer;
import org.jclouds.opsource.servers.domain.MachineSpecification;
import org.jclouds.opsource.servers.domain.Status;

@XmlRootElement(namespace="http://oec.api.opsource.net/schemas/server", name="DeployedServer")
public class DeployedServer
extends BaseServer {
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="id")
    private String id;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="name")
    private String name;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="description")
    private String description;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="machineSpecification")
    private MachineSpecification machineSpecification;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="sourceImageId")
    private String sourceImageId;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="networkId")
    private String networkId;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="privateIpAddress")
    private String privateIpAddress;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="publicIpAddress")
    private String publicIpAddress;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="machineName")
    private String machineName;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="isStarted")
    private boolean isStarted;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="deployedTime")
    private String deployedTime;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="status")
    private Status status;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromDeployedServer(this);
    }

    private DeployedServer() {
    }

    private DeployedServer(String id, String name, String description, MachineSpecification machineSpecification, String sourceImageId, String networkId, String privateIpAddress, String publicIpAddress, String machineName, boolean isStarted, String deployedTime, Status status) {
        super(id, name, description);
        this.machineSpecification = machineSpecification;
        this.sourceImageId = sourceImageId;
        this.networkId = networkId;
        this.privateIpAddress = privateIpAddress;
        this.publicIpAddress = publicIpAddress;
        this.machineName = machineName;
        this.isStarted = isStarted;
        this.deployedTime = deployedTime;
        this.status = status;
    }

    public MachineSpecification getMachineSpecification() {
        return this.machineSpecification;
    }

    public String getSourceImageId() {
        return this.sourceImageId;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public String getPublicIpAddress() {
        return this.publicIpAddress;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public String getDeployedTime() {
        return this.deployedTime;
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode((Object[])new Object[]{this.id, this.name, this.description, this.machineSpecification, this.sourceImageId, this.networkId, this.privateIpAddress, this.publicIpAddress, this.machineName, this.isStarted, this.deployedTime, this.status});
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("machineSpecification", (Object)this.machineSpecification).add("sourceImageId", (Object)this.sourceImageId).add("networkId", (Object)this.networkId).add("privateIpAddress", (Object)this.privateIpAddress).add("publicIpAddress", (Object)this.publicIpAddress).add("machineName", (Object)this.machineName).add("isStarted", this.isStarted).add("deployedTime", (Object)this.deployedTime).add("status", (Object)this.status).toString();
    }

    public static class Builder {
        private String id;
        private String name;
        private String description;
        private MachineSpecification machineSpecification;
        private String sourceImageId;
        private String networkId;
        private String privateIpAddress;
        private String publicIpAddress;
        private String machineName;
        private boolean isStarted;
        private String deployedTime;
        private Status status;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder machineSpecification(MachineSpecification machineSpecification) {
            this.machineSpecification = machineSpecification;
            return this;
        }

        public Builder sourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
            return this;
        }

        public Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public Builder machineName(String machineName) {
            this.machineName = machineName;
            return this;
        }

        public Builder isStarted(boolean isStarted) {
            this.isStarted = isStarted;
            return this;
        }

        public Builder deployedTime(String deployedTime) {
            this.deployedTime = deployedTime;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public DeployedServer build() {
            return new DeployedServer(this.id, this.name, this.description, this.machineSpecification, this.sourceImageId, this.networkId, this.privateIpAddress, this.publicIpAddress, this.machineName, this.isStarted, this.deployedTime, this.status);
        }

        public Builder fromDeployedServer(DeployedServer in) {
            return new Builder().id(this.id).name(this.name).description(this.description).machineSpecification(this.machineSpecification).sourceImageId(this.sourceImageId).networkId(this.networkId).privateIpAddress(this.privateIpAddress).publicIpAddress(this.publicIpAddress).machineName(this.machineName).isStarted(this.isStarted).deployedTime(this.deployedTime).status(this.status);
        }
    }
}

