/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.opsource.servers.domain.DeployedServer;

@XmlRootElement(namespace="http://oec.api.opsource.net/schemas/server", name="DeployedServers")
public class DeployedServersList {
    @XmlElement(name="DeployedServer", namespace="http://oec.api.opsource.net/schemas/server")
    private Set<DeployedServer> deployedServers = Sets.newLinkedHashSet();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder();
    }

    private DeployedServersList() {
    }

    private DeployedServersList(Set<DeployedServer> deployedServers) {
        this.deployedServers = ImmutableSet.copyOf(deployedServers);
    }

    public Set<DeployedServer> getDeployedServers() {
        return this.deployedServers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeployedServersList that = (DeployedServersList)DeployedServersList.class.cast(o);
        return super.equals(that) && Objects.equal(this.deployedServers, that.deployedServers);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deployedServers});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("deployedServers", this.deployedServers).toString();
    }

    public static class Builder {
        Set<DeployedServer> deployedServers = Sets.newLinkedHashSet();

        public Builder deployedServers(Set<DeployedServer> deployedServers) {
            this.deployedServers = Sets.newLinkedHashSet((Iterable)((Iterable)Preconditions.checkNotNull(deployedServers, (Object)"deployedServers")));
            return this;
        }

        public Builder deployedServer(DeployedServer deployedServer) {
            this.deployedServers.add((DeployedServer)Preconditions.checkNotNull((Object)deployedServer, (Object)"deployedServer"));
            return this;
        }

        public DeployedServersList build() {
            return new DeployedServersList(this.deployedServers);
        }
    }
}

