/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.domain;

import com.google.common.base.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.opsource.servers.domain.OperatingSystem;

@XmlRootElement(name="machineSpecification", namespace="http://oec.api.opsource.net/schemas/server")
public class MachineSpecification {
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server")
    private int cpuCount;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server")
    private long memoryMb;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server")
    private long osStorageGb;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server")
    private long additionalLocalStorageGb;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server")
    private OperatingSystem operatingSystem;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromMachineSpecification(this);
    }

    private MachineSpecification() {
    }

    private MachineSpecification(int cpuCount, long memoryMb, long osStorageGb, long additionalLocalStorageGb, OperatingSystem operatingSystem) {
        this.cpuCount = cpuCount;
        this.memoryMb = memoryMb;
        this.osStorageGb = osStorageGb;
        this.additionalLocalStorageGb = additionalLocalStorageGb;
        this.operatingSystem = operatingSystem;
    }

    public int getCpuCount() {
        return this.cpuCount;
    }

    public long getMemoryMb() {
        return this.memoryMb;
    }

    public long getOsStorageGb() {
        return this.osStorageGb;
    }

    public long getAdditionalLocalStorageGb() {
        return this.additionalLocalStorageGb;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineSpecification that = (MachineSpecification)MachineSpecification.class.cast(o);
        return Objects.equal((Object)this, (Object)that);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cpuCount, this.memoryMb, this.osStorageGb, this.additionalLocalStorageGb, this.operatingSystem});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("cpuCount", this.cpuCount).add("memoryMb", this.memoryMb).add("osStorageGb", this.osStorageGb).add("additionalLocalStorageGb", this.additionalLocalStorageGb).add("operatingSystem", (Object)this.operatingSystem).toString();
    }

    public static class Builder {
        private int cpuCount;
        private long memoryMb;
        private long osStorageGb;
        private long additionalLocalStorageGb;
        private OperatingSystem operatingSystem;

        public Builder cpuCount(int cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public Builder memoryMb(long memoryMb) {
            this.memoryMb = memoryMb;
            return this;
        }

        public Builder osStorageGb(long osStorageGb) {
            this.osStorageGb = osStorageGb;
            return this;
        }

        public Builder additionalLocalStorageGb(long additionalLocalStorageGb) {
            this.additionalLocalStorageGb = additionalLocalStorageGb;
            return this;
        }

        public Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public MachineSpecification build() {
            return new MachineSpecification(this.cpuCount, this.memoryMb, this.osStorageGb, this.additionalLocalStorageGb, this.operatingSystem);
        }

        public Builder fromMachineSpecification(MachineSpecification in) {
            return new Builder().cpuCount(this.cpuCount).memoryMb(this.memoryMb).osStorageGb(this.osStorageGb).additionalLocalStorageGb(this.additionalLocalStorageGb).operatingSystem(this.operatingSystem);
        }
    }
}

