/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.domain;

import com.google.common.base.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="operatingSystem", namespace="http://oec.api.opsource.net/schemas/server")
public class OperatingSystem {
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="type")
    private String osType;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="displayName")
    private String displayName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromOperatingSystem(this);
    }

    private OperatingSystem() {
    }

    private OperatingSystem(String osType, String displayName) {
        this.osType = osType;
        this.displayName = displayName;
    }

    public String getOsType() {
        return this.osType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatingSystem that = (OperatingSystem)OperatingSystem.class.cast(o);
        return Objects.equal((Object)this.osType, (Object)that.osType) && Objects.equal((Object)this.displayName, (Object)that.displayName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.osType, this.displayName});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("osType", (Object)this.osType).add("displayName", (Object)this.displayName).toString();
    }

    public static class Builder {
        private String osType;
        private String displayName;

        public Builder osType(String osType) {
            this.osType = osType;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public OperatingSystem build() {
            return new OperatingSystem(this.osType, this.displayName);
        }

        public Builder fromOperatingSystem(OperatingSystem in) {
            return new Builder().osType(in.getOsType()).displayName(in.getDisplayName());
        }
    }
}

