/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.opsource.servers.domain.PendingDeployServer;

@XmlRootElement(namespace="http://oec.api.opsource.net/schemas/server", name="PendingDeployServers")
public class PendingDeployServersList {
    @XmlElement(name="PendingDeployServer", namespace="http://oec.api.opsource.net/schemas/server")
    private Set<PendingDeployServer> pendingDeployServers = Sets.newLinkedHashSet();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder();
    }

    private PendingDeployServersList() {
    }

    private PendingDeployServersList(Set<PendingDeployServer> pendingDeployServers) {
        this.pendingDeployServers = ImmutableSet.copyOf(pendingDeployServers);
    }

    public Set<PendingDeployServer> getPendingDeployServers() {
        return this.pendingDeployServers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PendingDeployServersList that = (PendingDeployServersList)PendingDeployServersList.class.cast(o);
        return super.equals(that) && Objects.equal(this.pendingDeployServers, that.pendingDeployServers);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pendingDeployServers});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("pendingDeployServers", this.pendingDeployServers).toString();
    }

    public static class Builder {
        Set<PendingDeployServer> pendingDeployServers = Sets.newLinkedHashSet();

        public Builder pendingDeployServers(Set<PendingDeployServer> pendingDeployServers) {
            this.pendingDeployServers = Sets.newLinkedHashSet((Iterable)((Iterable)Preconditions.checkNotNull(pendingDeployServers, (Object)"pendingDeployServers")));
            return this;
        }

        public Builder pendingDeployServer(PendingDeployServer pendingDeployServer) {
            this.pendingDeployServers.add((PendingDeployServer)Preconditions.checkNotNull((Object)pendingDeployServer, (Object)"pendingDeployServer"));
            return this;
        }

        public PendingDeployServersList build() {
            return new PendingDeployServersList(this.pendingDeployServers);
        }
    }
}

