/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.domain;

import com.google.common.base.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.opsource.servers.domain.OperatingSystem;

@XmlRootElement(namespace="http://oec.api.opsource.net/schemas/server", name="ServerImage")
public class ServerImage {
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="id")
    private String id;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="resourcePath")
    private String resourcePath;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="name")
    private String name;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="description")
    private String description;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="operatingSystem")
    private OperatingSystem operatingSystem;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="location")
    private String location;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="cpuCount")
    private long cpuCount;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="memory")
    private long memory;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="osStorage")
    private long osStorage;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="additionalLocalStorage")
    private long additionalLocalStorage;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromServerImage(this);
    }

    private ServerImage() {
    }

    private ServerImage(String id, String resourcePath, String name, String description, OperatingSystem operatingSystem, String location, long cpuCount, long memory, long osStorage, long additionalLocalStorage) {
        this.id = id;
        this.resourcePath = resourcePath;
        this.name = name;
        this.description = description;
        this.operatingSystem = operatingSystem;
        this.location = location;
        this.cpuCount = cpuCount;
        this.memory = memory;
        this.osStorage = osStorage;
        this.additionalLocalStorage = additionalLocalStorage;
    }

    public String getId() {
        return this.id;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getLocation() {
        return this.location;
    }

    public long getCpuCount() {
        return this.cpuCount;
    }

    public long getMemory() {
        return this.memory;
    }

    public long getOsStorage() {
        return this.osStorage;
    }

    public long getAdditionalLocalStorage() {
        return this.additionalLocalStorage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerImage that = (ServerImage)ServerImage.class.cast(o);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.resourcePath, this.name, this.description, this.operatingSystem, this.location, this.cpuCount, this.memory, this.osStorage, this.additionalLocalStorage});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("resourcePath", (Object)this.resourcePath).add("name", (Object)this.name).add("description", (Object)this.description).add("operatingSystem", (Object)this.operatingSystem).add("location", (Object)this.location).add("cpuCount", this.cpuCount).add("memory", this.memory).add("osStorage", this.osStorage).add("additionalLocalStorage", this.additionalLocalStorage).toString();
    }

    public static class Builder {
        private String id;
        private String resourcePath;
        private String name;
        private String description;
        private OperatingSystem operatingSystem;
        private String location;
        private int cpuCount;
        private long memory;
        private long osStorage;
        private long additionalLocalStorage;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder cpuCount(int cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public Builder memory(long memory) {
            this.memory = memory;
            return this;
        }

        public Builder osStorage(long osStorage) {
            this.osStorage = osStorage;
            return this;
        }

        public Builder additionalLocalStorage(long additionalLocalStorage) {
            this.additionalLocalStorage = additionalLocalStorage;
            return this;
        }

        public ServerImage build() {
            return new ServerImage(this.id, this.resourcePath, this.name, this.description, this.operatingSystem, this.location, this.cpuCount, this.memory, this.osStorage, this.additionalLocalStorage);
        }

        public Builder fromServerImage(ServerImage in) {
            return new Builder().id(this.id).resourcePath(this.resourcePath).name(this.name).description(this.description).operatingSystem(this.operatingSystem).location(this.location).cpuCount(this.cpuCount).memory(this.memory).osStorage(this.osStorage).additionalLocalStorage(this.additionalLocalStorage);
        }
    }
}

