/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.opsource.servers.domain.ServerImage;

@XmlRootElement(namespace="http://oec.api.opsource.net/schemas/server", name="ServerImages")
public class ServerImagesList {
    @XmlElement(name="ServerImage", namespace="http://oec.api.opsource.net/schemas/server")
    private Set<ServerImage> serverImages = Sets.newLinkedHashSet();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder();
    }

    private ServerImagesList() {
    }

    private ServerImagesList(Set<ServerImage> serverImages) {
        this.serverImages = ImmutableSet.copyOf(serverImages);
    }

    public Set<ServerImage> getServerImages() {
        return this.serverImages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerImagesList that = (ServerImagesList)ServerImagesList.class.cast(o);
        return super.equals(that) && Objects.equal(this.serverImages, that.serverImages);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.serverImages});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("serverImages", this.serverImages).toString();
    }

    public static class Builder {
        Set<ServerImage> serverImages = Sets.newLinkedHashSet();

        public Builder dataCenters(Set<ServerImage> serverImages) {
            this.serverImages = Sets.newLinkedHashSet((Iterable)((Iterable)Preconditions.checkNotNull(serverImages, (Object)"serverImages")));
            return this;
        }

        public Builder serverImage(ServerImage serverImage) {
            this.serverImages.add((ServerImage)Preconditions.checkNotNull((Object)serverImage, (Object)"serverImage"));
            return this;
        }

        public ServerImagesList build() {
            return new ServerImagesList(this.serverImages);
        }
    }
}

