/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.opsource.servers.domain;

import com.google.common.base.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.opsource.servers.domain.Step;

@XmlRootElement(namespace="http://oec.api.opsource.net/schemas/server", name="status")
public class Status {
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="action")
    private String action;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="requestTime")
    private String requestTime;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="userName")
    private String userName;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="numberOfSteps")
    private int numberOfSteps;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="updateTime")
    private String updateTime;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="step")
    private Step step;
    @XmlElement(namespace="http://oec.api.opsource.net/schemas/server", name="failureReason")
    private String failureReason;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromStatus(this);
    }

    private Status() {
    }

    private Status(String action, String requestTime, String userName, int numberOfSteps, String updateTime, Step step, String failureReason) {
        this.action = action;
        this.requestTime = requestTime;
        this.userName = userName;
        this.numberOfSteps = numberOfSteps;
        this.updateTime = updateTime;
        this.step = step;
        this.failureReason = failureReason;
    }

    public String getAction() {
        return this.action;
    }

    public String getRequestTime() {
        return this.requestTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public Step getStep() {
        return this.step;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status that = (Status)Status.class.cast(o);
        return Objects.equal((Object)this, (Object)that);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.action, this.requestTime, this.userName, this.numberOfSteps, this.updateTime, this.step, this.failureReason});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("action", (Object)this.action).add("requestTime", (Object)this.requestTime).add("userName", (Object)this.userName).add("numberOfSteps", this.numberOfSteps).add("updateTime", (Object)this.updateTime).add("step", (Object)this.step).add("failureReason", (Object)this.failureReason).toString();
    }

    public static class Builder {
        private String action;
        private String requestTime;
        private String userName;
        private int numberOfSteps;
        private String updateTime;
        private Step step;
        private String failureReason;

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder requestTime(String requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder numberOfSteps(int numberOfSteps) {
            this.numberOfSteps = numberOfSteps;
            return this;
        }

        public Builder updateTime(String updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public Builder step(Step step) {
            this.step = step;
            return this;
        }

        public Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public Status build() {
            return new Status(this.action, this.requestTime, this.userName, this.numberOfSteps, this.updateTime, this.step, this.failureReason);
        }

        public Builder fromStatus(Status in) {
            return new Builder().action(this.action).requestTime(this.requestTime).userName(this.userName).numberOfSteps(this.numberOfSteps).updateTime(this.updateTime).step(this.step).failureReason(this.failureReason);
        }
    }
}

