/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.commonstext;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.commonstext.StringSubstitutorTemplateEngine;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementContextAccess;
import org.junit.jupiter.api.Test;

public class TestStringSubstitutorTemplateEngine {
    private StatementContext ctx = StatementContextAccess.createContext();

    @Test
    public void testDefaults() {
        this.ctx.define("name", (Object)"foo");
        Assertions.assertThat((String)new StringSubstitutorTemplateEngine().render("create table ${name};", this.ctx)).isEqualTo("create table foo;");
    }

    @Test
    public void testMissingAttribute() {
        StringSubstitutorTemplateEngine engine = StringSubstitutorTemplateEngine.between((char)'<', (char)'>');
        Assertions.assertThat((String)engine.render("select * from foo where x=<x>", this.ctx)).isEqualTo("select * from foo where x=<x>");
    }

    @Test
    public void testNullAttribute() {
        this.ctx.define("x", null);
        StringSubstitutorTemplateEngine engine = StringSubstitutorTemplateEngine.between((char)'<', (char)'>');
        Assertions.assertThat((String)engine.render("select * from foo where x=<x>", this.ctx)).isEqualTo("select * from foo where x=<x>");
    }

    @Test
    public void testCustomPrefixSuffix() {
        this.ctx.define("name", (Object)"foo");
        StringSubstitutorTemplateEngine engine = StringSubstitutorTemplateEngine.between((char)'<', (char)'>');
        Assertions.assertThat((String)engine.render("create table <name>;", this.ctx)).isEqualTo("create table foo;");
    }

    @Test
    public void testEscapeCharacter() {
        this.ctx.define("name", (Object)"foo");
        StringSubstitutorTemplateEngine engine = StringSubstitutorTemplateEngine.between((char)'<', (char)'>', (char)'@');
        Assertions.assertThat((String)engine.render("create table @<name>;", this.ctx)).isEqualTo("create table <name>;");
    }
}

