/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.commonstext;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.commonstext.StringSubstitutorTemplateEngine;
import org.jdbi.v3.commonstext.UseStringSubstitutorTemplateEngine;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.UseTemplateEngine;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestUseStringSubstitutorTemplateEngine {
    @RegisterExtension
    public JdbiExtension sqliteExtension = JdbiExtension.sqlite().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Jdbi jdbi;

    @BeforeEach
    public void before() {
        this.jdbi = (Jdbi)this.sqliteExtension.getJdbi().setTemplateEngine(TemplateEngine.NOP);
    }

    @Test
    public void testUseTemplateEngine() {
        String selected = (String)this.jdbi.withExtension(Queries1.class, q -> q.select("foo"));
        Assertions.assertThat((String)selected).isEqualTo("foo");
    }

    @Test
    public void testCustomAnnotation() {
        String selected = (String)this.jdbi.withExtension(Queries2.class, q -> q.select("foo"));
        Assertions.assertThat((String)selected).isEqualTo("foo");
    }

    public static interface Queries1 {
        @UseTemplateEngine(value=StringSubstitutorTemplateEngine.class)
        @SqlQuery(value="select * from (values('${v}'))")
        public String select(@Define(value="v") String var1);
    }

    public static interface Queries2 {
        @UseStringSubstitutorTemplateEngine(prefix="_", suffix="_")
        @SqlQuery(value="select * from (values('_v_'))")
        public String select(@Define(value="v") String var1);
    }
}

