/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.json.internal;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Supplier;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.json.EncodedJson;
import org.jdbi.v3.json.Json;
import org.jdbi.v3.json.JsonConfig;

@Json
public class JsonArgumentFactory
implements ArgumentFactory {
    private static final String JSON_NOT_STORABLE = String.format("No argument factory found for `@%s String` or 'String'", EncodedJson.class.getSimpleName());

    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        String nullableJson = value == null ? null : ((JsonConfig)config.get(JsonConfig.class)).getJsonMapper().toJson(type, value, config);
        String json = "null".equals(nullableJson) ? null : nullableJson;
        Arguments a = (Arguments)config.get(Arguments.class);
        return Optional.of((Argument)JdbiOptionals.findFirstPresent((Supplier[])new Supplier[]{() -> a.findFor(QualifiedType.of(String.class).with(new Class[]{EncodedJson.class}), (Object)json), () -> a.findFor(String.class, (Object)json)}).orElseThrow(() -> new UnableToCreateStatementException(JSON_NOT_STORABLE)));
    }
}

