/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.kotlin;

import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.test.AssertionsKt;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;
import org.jdbi.v3.core.qualifier.Reversed;
import org.jdbi.v3.core.qualifier.ReversedStringArgumentFactory;
import org.jdbi.v3.core.qualifier.ReversedStringMapper;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactory;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapper;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMappers;
import org.jdbi.v3.sqlobject.kotlin.ExtensionsKt;
import org.jdbi.v3.sqlobject.kotlin.RegisterKotlinMapper;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Rule;
import org.junit.Test;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0005\u0012\u0013\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0007J\b\u0010\u000b\u001a\u00020\u0007H\u0007J\b\u0010\f\u001a\u00020\u0007H\u0007J\b\u0010\r\u001a\u00020\u0007H\u0007J\b\u0010\u000e\u001a\u00020\u0007H\u0007J\b\u0010\u000f\u001a\u00020\u0007H\u0007J\b\u0010\u0010\u001a\u00020\u0007H\u0007J\b\u0010\u0011\u001a\u00020\u0007H\u0007R\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest;", "", "()V", "db", "Lorg/jdbi/v3/core/rule/H2DatabaseRule;", "kotlin.jvm.PlatformType", "commonTest", "", "dao", "Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$ThingDao;", "qualifiedBindParameter", "testDaoCanAttachViaDbiOnDemand", "testDaoCanAttachViaDbiOnDemandWithKClassArgument", "testDaoCanAttachViaHandleAttach", "testDaoCanAttachViaHandleAttachWithKClassArgument", "testDataClassWithJdbiConstructor", "testDefaultMethod", "testDefaultMethodShouldPropagateException", "DataClassWithJdbiConstructor", "QualifiedDao", "TestDao", "Thing", "ThingDao", "jdbi3-kotlin-sqlobject"})
public final class KotlinSqlObjectPluginTest {
    @Rule
    @JvmField
    public final H2DatabaseRule db = new H2DatabaseRule().withSomething().withPlugins();

    private final void commonTest(ThingDao dao) {
        Thing brian = new Thing(1, "Brian", null, null, null, null, 56, null);
        Thing keith = new Thing(2, "Keith", null, null, null, null, 56, null);
        dao.insert(brian);
        dao.insert(keith);
        List<Thing> rs = dao.list();
        AssertionsKt.assertEquals$default((Object)2L, (Object)rs.size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)brian, (Object)rs.get(0), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)keith, (Object)rs.get(1), null, (int)4, null);
        Thing foundThing = dao.findById(2);
        AssertionsKt.assertEquals$default((Object)keith, (Object)foundThing, null, (int)4, null);
        Thing foundThingWithAlias = dao.findByIdWithAlias(2);
        AssertionsKt.assertEquals$default((Object)keith, (Object)foundThingWithAlias, null, (int)4, null);
        List<Thing> rs2 = dao.listWithNulls();
        AssertionsKt.assertEquals$default((Object)2L, (Object)rs2.size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Thing.copy$default(brian, 0, null, null, null, null, "test", 3, null), (Object)rs2.get(0), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Thing.copy$default(keith, 0, null, null, null, null, "test", 3, null), (Object)rs2.get(1), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testDaoCanAttachViaDbiOnDemand() {
        void $this$onDemand$iv;
        Jdbi jdbi = this.db.getJdbi();
        Intrinsics.checkNotNullExpressionValue((Object)jdbi, (String)"db.jdbi");
        boolean $i$f$onDemand = false;
        Object object = $this$onDemand$iv.onDemand(ThingDao.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.onDemand(T::class.java)");
        this.commonTest((ThingDao)object);
    }

    @Test
    public final void testDaoCanAttachViaDbiOnDemandWithKClassArgument() {
        Jdbi jdbi = this.db.getJdbi();
        Intrinsics.checkNotNullExpressionValue((Object)jdbi, (String)"db.jdbi");
        this.commonTest((ThingDao)ExtensionsKt.onDemand((Jdbi)jdbi, (KClass)Reflection.getOrCreateKotlinClass(ThingDao.class)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testDaoCanAttachViaHandleAttach() {
        void $this$attach$iv;
        Handle handle = this.db.getSharedHandle();
        Intrinsics.checkNotNullExpressionValue((Object)handle, (String)"db.sharedHandle");
        boolean $i$f$attach = false;
        Object object = $this$attach$iv.attach(ThingDao.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.attach(T::class.java)");
        this.commonTest((ThingDao)object);
    }

    @Test
    public final void testDaoCanAttachViaHandleAttachWithKClassArgument() {
        Handle handle = this.db.getSharedHandle();
        Intrinsics.checkNotNullExpressionValue((Object)handle, (String)"db.sharedHandle");
        this.commonTest((ThingDao)ExtensionsKt.attach((Handle)handle, (KClass)Reflection.getOrCreateKotlinClass(ThingDao.class)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testDefaultMethod() {
        void $this$onDemand$iv;
        Jdbi jdbi = this.db.getJdbi();
        Intrinsics.checkNotNullExpressionValue((Object)jdbi, (String)"db.jdbi");
        boolean $i$f$onDemand = false;
        Object object = $this$onDemand$iv.onDemand(ThingDao.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.onDemand(T::class.java)");
        ThingDao dao = (ThingDao)object;
        Thing brian = new Thing(1, "Brian", null, null, null, null, 56, null);
        Thing found = dao.insertAndFind(brian);
        AssertionsKt.assertEquals$default((Object)brian, (Object)found, null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testDefaultMethodShouldPropagateException() {
        Object object;
        void $this$onDemand$iv;
        Jdbi jdbi = this.db.getJdbi();
        Intrinsics.checkNotNullExpressionValue((Object)jdbi, (String)"db.jdbi");
        boolean $i$f$onDemand = false;
        Object object2 = $this$onDemand$iv.onDemand(ThingDao.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this.onDemand(T::class.java)");
        ThingDao dao = (ThingDao)object2;
        UnsupportedOperationException exception = new UnsupportedOperationException("Testing exception propagation");
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        try {
            object = Result.Companion;
            boolean bl3 = false;
            dao.throwsException(exception);
            Unit unit = Unit.INSTANCE;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl5 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object3 = object;
        Throwable actualException = AssertionsKt.checkResultIsFailure(string, (Object)object3);
        AssertionsKt.assertEquals$default((Object)exception, (Object)actualException, null, (int)4, null);
    }

    @Test
    public final void qualifiedBindParameter() {
        Query $this$onDemand$iv;
        Jdbi jdbi = this.db.getJdbi();
        Intrinsics.checkNotNullExpressionValue((Object)jdbi, (String)"db.jdbi");
        boolean $i$f$onDemand = false;
        Object object = $this$onDemand$iv.onDemand(QualifiedDao.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.onDemand(T::class.java)");
        QualifiedDao dao = (QualifiedDao)object;
        dao.insert(1, "abc");
        $this$onDemand$iv = this.db.getSharedHandle().select("SELECT name FROM something WHERE id = 1", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)$this$onDemand$iv, (String)"db.sharedHandle\n            .select(\"SELECT name FROM something WHERE id = 1\")");
        ResultBearing $this$mapTo$iv = (ResultBearing)$this$onDemand$iv;
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv.mapTo(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.mapTo(T::class.java)");
        Assertions.assertThat((String)((String)object.one())).isEqualTo("cba");
        this.db.getSharedHandle().execute("insert into something (id, name) values (2, 'xyz')", new Object[0]);
        Assertions.assertThat((String)dao.select(2)).isEqualTo("zyx");
    }

    @Test
    public final void testDataClassWithJdbiConstructor() {
        this.db.getSharedHandle().execute("CREATE TABLE bean (s varchar, i integer)", new Object[0]);
        this.db.getSharedHandle().execute("INSERT INTO bean VALUES('x', 2)", new Object[0]);
        TestDao dao = (TestDao)this.db.getJdbi().onDemand(TestDao.class);
        DataClassWithJdbiConstructor result = dao.findOne("x");
        Assertions.assertThat((String)result.getS()).isEqualTo("x");
        Assertions.assertThat((int)result.getI()).isEqualTo(2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003JK\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$Thing;", "", "id", "", "name", "", "nullable", "nullableDefaultedNull", "nullableDefaultedNotNull", "defaulted", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDefaulted", "()Ljava/lang/String;", "getId", "()I", "getName", "getNullable", "getNullableDefaultedNotNull", "getNullableDefaultedNull", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "jdbi3-kotlin-sqlobject"})
    public static final class Thing {
        private final int id;
        @NotNull
        private final String name;
        @Nullable
        private final String nullable;
        @Nullable
        private final String nullableDefaultedNull;
        @Nullable
        private final String nullableDefaultedNotNull;
        @NotNull
        private final String defaulted;

        public Thing(int id, @NotNull String name, @Nullable String nullable, @Nullable String nullableDefaultedNull, @Nullable String nullableDefaultedNotNull, @NotNull String defaulted) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)defaulted, (String)"defaulted");
            this.id = id;
            this.name = name;
            this.nullable = nullable;
            this.nullableDefaultedNull = nullableDefaultedNull;
            this.nullableDefaultedNotNull = nullableDefaultedNotNull;
            this.defaulted = defaulted;
        }

        public /* synthetic */ Thing(int n, String string, String string2, String string3, String string4, String string5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string3 = null;
            }
            if ((n2 & 0x10) != 0) {
                string4 = "not null";
            }
            if ((n2 & 0x20) != 0) {
                string5 = "default value";
            }
            this(n, string, string2, string3, string4, string5);
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getNullable() {
            return this.nullable;
        }

        @Nullable
        public final String getNullableDefaultedNull() {
            return this.nullableDefaultedNull;
        }

        @Nullable
        public final String getNullableDefaultedNotNull() {
            return this.nullableDefaultedNotNull;
        }

        @NotNull
        public final String getDefaulted() {
            return this.defaulted;
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final String component3() {
            return this.nullable;
        }

        @Nullable
        public final String component4() {
            return this.nullableDefaultedNull;
        }

        @Nullable
        public final String component5() {
            return this.nullableDefaultedNotNull;
        }

        @NotNull
        public final String component6() {
            return this.defaulted;
        }

        @NotNull
        public final Thing copy(int id, @NotNull String name, @Nullable String nullable, @Nullable String nullableDefaultedNull, @Nullable String nullableDefaultedNotNull, @NotNull String defaulted) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)defaulted, (String)"defaulted");
            return new Thing(id, name, nullable, nullableDefaultedNull, nullableDefaultedNotNull, defaulted);
        }

        public static /* synthetic */ Thing copy$default(Thing thing, int n, String string, String string2, String string3, String string4, String string5, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = thing.id;
            }
            if ((n2 & 2) != 0) {
                string = thing.name;
            }
            if ((n2 & 4) != 0) {
                string2 = thing.nullable;
            }
            if ((n2 & 8) != 0) {
                string3 = thing.nullableDefaultedNull;
            }
            if ((n2 & 0x10) != 0) {
                string4 = thing.nullableDefaultedNotNull;
            }
            if ((n2 & 0x20) != 0) {
                string5 = thing.defaulted;
            }
            return thing.copy(n, string, string2, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "Thing(id=" + this.id + ", name=" + this.name + ", nullable=" + this.nullable + ", nullableDefaultedNull=" + this.nullableDefaultedNull + ", nullableDefaultedNotNull=" + this.nullableDefaultedNotNull + ", defaulted=" + this.defaulted + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.id);
            result = result * 31 + this.name.hashCode();
            result = result * 31 + (this.nullable == null ? 0 : this.nullable.hashCode());
            result = result * 31 + (this.nullableDefaultedNull == null ? 0 : this.nullableDefaultedNull.hashCode());
            result = result * 31 + (this.nullableDefaultedNotNull == null ? 0 : this.nullableDefaultedNotNull.hashCode());
            result = result * 31 + this.defaulted.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Thing)) {
                return false;
            }
            Thing thing = (Thing)other;
            if (this.id != thing.id) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)thing.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nullable, (Object)thing.nullable)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nullableDefaultedNull, (Object)thing.nullableDefaultedNull)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nullableDefaultedNotNull, (Object)thing.nullableDefaultedNotNull)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.defaulted, (Object)thing.defaulted);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H'J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\fH'J\u0014\u0010\u000e\u001a\u00020\u00032\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$ThingDao;", "Lorg/jdbi/v3/sqlobject/SqlObject;", "findById", "Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$Thing;", "id", "", "findByIdWithAlias", "insert", "", "something", "insertAndFind", "list", "", "listWithNulls", "throwsException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "jdbi3-kotlin-sqlobject"})
    public static interface ThingDao
    extends SqlObject {
        @SqlUpdate(value="insert into something (id, name) values (:something.id, :something.name)")
        public void insert(@NotNull Thing var1);

        @NotNull
        public List<Thing> list();

        @SqlQuery(value="select id, name, null as nullable, null as nullableDefaultedNull, null as nullableDefaultedNotNull, 'test' as defaulted from something")
        @NotNull
        public List<Thing> listWithNulls();

        @SqlQuery(value="select id, name from something where id=:id")
        @NotNull
        public Thing findById(int var1);

        @SqlQuery(value="select id as t_id, name as t_name from something where id=:id")
        @RegisterKotlinMapper(value=Thing.class, prefix="t")
        @NotNull
        public Thing findByIdWithAlias(int var1);

        @NotNull
        public Thing insertAndFind(@NotNull Thing var1);

        @NotNull
        public Thing throwsException(@NotNull Exception var1);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static List<Thing> list(@NotNull ThingDao this_) {
                Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
                List list = this_.getHandle().createQuery("select id, name from something").mapTo(Thing.class).list();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"handle.createQuery(\"select id, name from something\")\n                    .mapTo(Thing::class.java)\n                    .list()");
                return list;
            }

            @NotNull
            public static Thing insertAndFind(@NotNull ThingDao this_, @NotNull Thing something) {
                Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
                Intrinsics.checkNotNullParameter((Object)something, (String)"something");
                this_.insert(something);
                return this_.findById(something.getId());
            }

            @NotNull
            public static Thing throwsException(@NotNull ThingDao this_, @NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                throw e;
            }
        }
    }

    @RegisterArgumentFactory(value=ReversedStringArgumentFactory.class)
    @RegisterColumnMapper(value=ReversedStringMapper.class)
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H'\u00a8\u0006\t"}, d2={"Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$QualifiedDao;", "", "insert", "", "id", "", "name", "", "select", "jdbi3-kotlin-sqlobject"})
    public static interface QualifiedDao {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(int var1, @Reversed @NotNull String var2);

        @SqlQuery(value="select name from something where id = :id")
        @Reversed
        @NotNull
        public String select(int var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$DataClassWithJdbiConstructor;", "", "s", "", "i", "", "(Ljava/lang/String;I)V", "getI", "()I", "getS", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "jdbi3-kotlin-sqlobject"})
    public static final class DataClassWithJdbiConstructor {
        @NotNull
        private final String s;
        private final int i;

        @JdbiConstructor
        public DataClassWithJdbiConstructor(@ColumnName(value="not_s") @NotNull String s, @ColumnName(value="i") int i) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.s = s;
            this.i = i;
        }

        public /* synthetic */ DataClassWithJdbiConstructor(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 5;
            }
            this(string, n);
        }

        @NotNull
        public final String getS() {
            return this.s;
        }

        public final int getI() {
            return this.i;
        }

        @NotNull
        public final String component1() {
            return this.s;
        }

        public final int component2() {
            return this.i;
        }

        @NotNull
        public final DataClassWithJdbiConstructor copy(@ColumnName(value="not_s") @NotNull String s, @ColumnName(value="i") int i) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return new DataClassWithJdbiConstructor(s, i);
        }

        public static /* synthetic */ DataClassWithJdbiConstructor copy$default(DataClassWithJdbiConstructor dataClassWithJdbiConstructor, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = dataClassWithJdbiConstructor.s;
            }
            if ((n2 & 2) != 0) {
                n = dataClassWithJdbiConstructor.i;
            }
            return dataClassWithJdbiConstructor.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "DataClassWithJdbiConstructor(s=" + this.s + ", i=" + this.i + ')';
        }

        public int hashCode() {
            int result = this.s.hashCode();
            result = result * 31 + Integer.hashCode(this.i);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DataClassWithJdbiConstructor)) {
                return false;
            }
            DataClassWithJdbiConstructor dataClassWithJdbiConstructor = (DataClassWithJdbiConstructor)other;
            if (!Intrinsics.areEqual((Object)this.s, (Object)dataClassWithJdbiConstructor.s)) {
                return false;
            }
            return this.i == dataClassWithJdbiConstructor.i;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u00a8\u0006\u0006"}, d2={"Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$TestDao;", "", "findOne", "Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$DataClassWithJdbiConstructor;", "s", "", "jdbi3-kotlin-sqlobject"})
    public static interface TestDao {
        @SqlQuery(value="SELECT s as not_s, i as i from bean where s = :s")
        @RegisterConstructorMappers(value={@RegisterConstructorMapper(value=DataClassWithJdbiConstructor.class)})
        @NotNull
        public DataClassWithJdbiConstructor findOne(@NotNull String var1);
    }
}

