/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.kotlin;

import java.lang.reflect.Type;
import java.util.List;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.kotlin.ExtensionsKt;
import org.jdbi.v3.core.kotlin.KotlinMapper;
import org.jdbi.v3.core.kotlin.KotlinPlugin;
import org.jdbi.v3.core.mapper.JoinRow;
import org.jdbi.v3.core.mapper.JoinRowMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.kotlin.KotlinSqlObjectPlugin;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jdbi/v3/sqlobject/kotlin/Issue1944Test;", "", "()V", "h2Extension", "Lorg/jdbi/v3/testing/junit5/JdbiExtension;", "doTest", "", "jdbi", "Lorg/jdbi/v3/core/Jdbi;", "testNativeKotlin", "testWithKotlinMapperFactory", "testWithoutKotlinMapperFactory", "Product", "Tag", "jdbi3-kotlin-sqlobject"})
@SourceDebugExtension(value={"SMAP\nIssue1944Test.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Issue1944Test.kt\norg/jdbi/v3/sqlobject/kotlin/Issue1944Test\n+ 2 Extensions.kt\norg/jdbi/v3/core/kotlin/ExtensionsKt\n*L\n1#1,112:1\n58#2:113\n*S KotlinDebug\n*F\n+ 1 Issue1944Test.kt\norg/jdbi/v3/sqlobject/kotlin/Issue1944Test\n*L\n97#1:113\n*E\n"})
public final class Issue1944Test {
    @RegisterExtension
    @JvmField
    @NotNull
    public JdbiExtension h2Extension;

    public Issue1944Test() {
        JdbiPlugin[] jdbiPluginArray = new JdbiPlugin[]{new SqlObjectPlugin(), new KotlinSqlObjectPlugin()};
        JdbiExtension jdbiExtension = JdbiExtension.h2().withPlugins(jdbiPluginArray).withInitializer(Issue1944Test::h2Extension$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)jdbiExtension, (String)"h2()\n        .withPlugin\u2026}\n            )\n        }");
        this.h2Extension = jdbiExtension;
    }

    @Test
    public final void testWithKotlinMapperFactory(@NotNull Jdbi jdbi) {
        Intrinsics.checkNotNullParameter((Object)jdbi, (String)"jdbi");
        Type[] typeArray = new Type[]{Tag.class, Product.class};
        ((Jdbi)jdbi.installPlugin((JdbiPlugin)new KotlinPlugin(false, 1, null)).registerRowMapper((RowMapper)new KotlinMapper(Product.class, "p"))).registerRowMapper((RowMapper)JoinRowMapper.forTypes((Type[])typeArray));
        this.doTest(jdbi);
    }

    @Test
    public final void testWithoutKotlinMapperFactory(@NotNull Jdbi jdbi) {
        Intrinsics.checkNotNullParameter((Object)jdbi, (String)"jdbi");
        Type[] typeArray = new Type[]{Tag.class, Product.class};
        ((Jdbi)((Jdbi)jdbi.installPlugin((JdbiPlugin)new KotlinPlugin(false)).registerRowMapper((RowMapper)new KotlinMapper(Product.class, "p"))).registerRowMapper((RowMapper)new KotlinMapper(Tag.class, null, 2, null))).registerRowMapper((RowMapper)JoinRowMapper.forTypes((Type[])typeArray));
        this.doTest(jdbi);
    }

    @Test
    public final void testNativeKotlin(@NotNull Jdbi jdbi) {
        Intrinsics.checkNotNullParameter((Object)jdbi, (String)"jdbi");
        Type[] typeArray = new Type[]{Tag.class, Product.class};
        ((Jdbi)((Jdbi)jdbi.installPlugin((JdbiPlugin)new KotlinPlugin(false)).registerRowMapper((RowMapper)new KotlinMapper(Reflection.getOrCreateKotlinClass(Product.class), "p"))).registerRowMapper((RowMapper)new KotlinMapper(Reflection.getOrCreateKotlinClass(Tag.class), null, 2, null))).registerRowMapper((RowMapper)JoinRowMapper.forTypes((Type[])typeArray));
        this.doTest(jdbi);
    }

    public final void doTest(@NotNull Jdbi jdbi) {
        Intrinsics.checkNotNullParameter((Object)jdbi, (String)"jdbi");
        String sql = StringsKt.trimIndent((String)"\n            SELECT\n              t.id, t.name,\n              p.id pid, p.tagId ptagId, p.primaryName pprimaryName\n            FROM Tag t JOIN Product P ON t.id = p.TagId\n        ");
        List rows = (List)jdbi.withHandle(arg_0 -> Issue1944Test.doTest$lambda$2(sql, arg_0));
        Assertions.assertNotNull((Object)rows);
        Assertions.assertEquals((int)1, (int)rows.size());
        JoinRow joinRow = (JoinRow)rows.get(0);
        Assertions.assertEquals((int)1, (Integer)((Tag)joinRow.get(Tag.class)).getId());
        Assertions.assertEquals((Object)"foo", (Object)((Tag)joinRow.get(Tag.class)).getName());
        Assertions.assertEquals((int)2, (Integer)((Product)joinRow.get(Product.class)).getId(), (String)"Product::id mismatch");
        Assertions.assertEquals((Object)"stuff", (Object)((Product)joinRow.get(Product.class)).getPrimaryName());
        Assertions.assertEquals((int)1, (Integer)((Product)joinRow.get(Product.class)).getTagId());
    }

    private static final Object h2Extension$lambda$1$lambda$0(Handle h) {
        h.execute("CREATE TABLE Tag (id integer primary key, name VARCHAR(50))", new Object[0]);
        h.execute("CREATE TABLE Product (id integer primary key, primaryName varchar(50), tagId integer)", new Object[0]);
        h.execute("INSERT INTO Tag (id, name) VALUES (1, 'foo')", new Object[0]);
        return h.execute("INSERT INTO Product (id, primaryName, tagId) VALUES (2, 'stuff', 1)", new Object[0]);
    }

    private static final void h2Extension$lambda$1(DataSource dataSource, Handle handle) {
        handle.inTransaction(Issue1944Test::h2Extension$lambda$1$lambda$0);
    }

    private static final List doTest$lambda$2(String $sql, Handle handle) {
        Intrinsics.checkNotNullParameter((Object)$sql, (String)"$sql");
        Query query = handle.createQuery($sql);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"handle.createQuery(sql)");
        ResultBearing $this$mapTo$iv = (ResultBearing)query;
        boolean $i$f$mapTo = false;
        return ExtensionsKt.mapTo((ResultBearing)$this$mapTo$iv, (KClass)Reflection.getOrCreateKotlinClass(JoinRow.class)).list();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ2\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jdbi/v3/sqlobject/kotlin/Issue1944Test$Product;", "", "id", "", "primaryName", "", "tagId", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;)V", "getId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getPrimaryName", "()Ljava/lang/String;", "getTagId", "component1", "component2", "component3", "copy", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;)Lorg/jdbi/v3/sqlobject/kotlin/Issue1944Test$Product;", "equals", "", "other", "hashCode", "toString", "jdbi3-kotlin-sqlobject"})
    public static final class Product {
        @Nullable
        private final Integer id;
        @Nullable
        private final String primaryName;
        @Nullable
        private final Integer tagId;

        public Product(@Nullable Integer id, @Nullable String primaryName, @Nullable Integer tagId) {
            this.id = id;
            this.primaryName = primaryName;
            this.tagId = tagId;
        }

        @Nullable
        public final Integer getId() {
            return this.id;
        }

        @Nullable
        public final String getPrimaryName() {
            return this.primaryName;
        }

        @Nullable
        public final Integer getTagId() {
            return this.tagId;
        }

        @Nullable
        public final Integer component1() {
            return this.id;
        }

        @Nullable
        public final String component2() {
            return this.primaryName;
        }

        @Nullable
        public final Integer component3() {
            return this.tagId;
        }

        @NotNull
        public final Product copy(@Nullable Integer id, @Nullable String primaryName, @Nullable Integer tagId) {
            return new Product(id, primaryName, tagId);
        }

        public static /* synthetic */ Product copy$default(Product product, Integer n, String string, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = product.id;
            }
            if ((n3 & 2) != 0) {
                string = product.primaryName;
            }
            if ((n3 & 4) != 0) {
                n2 = product.tagId;
            }
            return product.copy(n, string, n2);
        }

        @NotNull
        public String toString() {
            return "Product(id=" + this.id + ", primaryName=" + this.primaryName + ", tagId=" + this.tagId + ")";
        }

        public int hashCode() {
            int result = this.id == null ? 0 : ((Object)this.id).hashCode();
            result = result * 31 + (this.primaryName == null ? 0 : this.primaryName.hashCode());
            result = result * 31 + (this.tagId == null ? 0 : ((Object)this.tagId).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Product)) {
                return false;
            }
            Product product = (Product)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)product.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.primaryName, (Object)product.primaryName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tagId, (Object)product.tagId);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J&\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jdbi/v3/sqlobject/kotlin/Issue1944Test$Tag;", "", "id", "", "name", "", "(Ljava/lang/Integer;Ljava/lang/String;)V", "getId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "(Ljava/lang/Integer;Ljava/lang/String;)Lorg/jdbi/v3/sqlobject/kotlin/Issue1944Test$Tag;", "equals", "", "other", "hashCode", "toString", "jdbi3-kotlin-sqlobject"})
    public static final class Tag {
        @Nullable
        private final Integer id;
        @Nullable
        private final String name;

        public Tag(@Nullable Integer id, @Nullable String name) {
            this.id = id;
            this.name = name;
        }

        @Nullable
        public final Integer getId() {
            return this.id;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Integer component1() {
            return this.id;
        }

        @Nullable
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final Tag copy(@Nullable Integer id, @Nullable String name) {
            return new Tag(id, name);
        }

        public static /* synthetic */ Tag copy$default(Tag tag, Integer n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = tag.id;
            }
            if ((n2 & 2) != 0) {
                string = tag.name;
            }
            return tag.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "Tag(id=" + this.id + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result = this.id == null ? 0 : ((Object)this.id).hashCode();
            result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Tag)) {
                return false;
            }
            Tag tag = (Tag)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)tag.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)tag.name);
        }
    }
}

