/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.kotlin;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;
import org.jdbi.v3.core.qualifier.Reversed;
import org.jdbi.v3.core.qualifier.ReversedStringArgumentFactory;
import org.jdbi.v3.core.qualifier.ReversedStringMapper;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactory;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapper;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMappers;
import org.jdbi.v3.sqlobject.kotlin.RegisterKotlinMapper;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Rule;
import org.junit.Test;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0005\u0010\u0011\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0007J\b\u0010\u000b\u001a\u00020\u0007H\u0007J\b\u0010\f\u001a\u00020\u0007H\u0007J\b\u0010\r\u001a\u00020\u0007H\u0007J\b\u0010\u000e\u001a\u00020\u0007H\u0007J\b\u0010\u000f\u001a\u00020\u0007H\u0007R\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest;", "", "()V", "db", "Lorg/jdbi/v3/core/rule/H2DatabaseRule;", "kotlin.jvm.PlatformType", "commonTest", "", "dao", "Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$ThingDao;", "qualifiedBindParameter", "testDaoCanAttachViaDbiOnDemand", "testDaoCanAttachViaHandleAttach", "testDataClassWithJdbiConstructor", "testDefaultMethod", "testDefaultMethodShouldPropagateException", "DataClassWithJdbiConstructor", "QualifiedDao", "TestDao", "Thing", "ThingDao", "jdbi3-kotlin-sqlobject"})
public final class KotlinSqlObjectPluginTest {
    @Rule
    @JvmField
    public final H2DatabaseRule db = new H2DatabaseRule().withSomething().withPlugins();

    private final void commonTest(ThingDao dao) {
        Thing brian = new Thing(1, "Brian", null, null, null, null, 56, null);
        Thing keith = new Thing(2, "Keith", null, null, null, null, 56, null);
        dao.insert(brian);
        dao.insert(keith);
        List<Thing> rs = dao.list();
        AssertionsKt.assertEquals$default((Object)2L, (Object)rs.size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)brian, (Object)rs.get(0), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)keith, (Object)rs.get(1), null, (int)4, null);
        Thing foundThing = dao.findById(2);
        AssertionsKt.assertEquals$default((Object)keith, (Object)foundThing, null, (int)4, null);
        Thing foundThingWithAlias = dao.findByIdWithAlias(2);
        AssertionsKt.assertEquals$default((Object)keith, (Object)foundThingWithAlias, null, (int)4, null);
        List<Thing> rs2 = dao.listWithNulls();
        AssertionsKt.assertEquals$default((Object)2L, (Object)rs2.size(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Thing.copy$default(brian, 0, null, null, null, null, "test", 3, null), (Object)rs2.get(0), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Thing.copy$default(keith, 0, null, null, null, null, "test", 3, null), (Object)rs2.get(1), null, (int)4, null);
    }

    @Test
    public final void testDaoCanAttachViaDbiOnDemand() {
        H2DatabaseRule h2DatabaseRule = this.db;
        Intrinsics.checkExpressionValueIsNotNull((Object)h2DatabaseRule, (String)"db");
        Jdbi jdbi = h2DatabaseRule.getJdbi();
        Intrinsics.checkExpressionValueIsNotNull((Object)jdbi, (String)"db.jdbi");
        Jdbi $receiver$iv = jdbi;
        KotlinSqlObjectPluginTest kotlinSqlObjectPluginTest = this;
        Object object = $receiver$iv.onDemand(ThingDao.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.onDemand(T::class.java)");
        Object object2 = object;
        kotlinSqlObjectPluginTest.commonTest((ThingDao)object2);
    }

    @Test
    public final void testDaoCanAttachViaHandleAttach() {
        H2DatabaseRule h2DatabaseRule = this.db;
        Intrinsics.checkExpressionValueIsNotNull((Object)h2DatabaseRule, (String)"db");
        Handle handle = h2DatabaseRule.getSharedHandle();
        Intrinsics.checkExpressionValueIsNotNull((Object)handle, (String)"db.sharedHandle");
        Handle $receiver$iv = handle;
        KotlinSqlObjectPluginTest kotlinSqlObjectPluginTest = this;
        Object object = $receiver$iv.attach(ThingDao.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.attach(T::class.java)");
        Object object2 = object;
        kotlinSqlObjectPluginTest.commonTest((ThingDao)object2);
    }

    @Test
    public final void testDefaultMethod() {
        H2DatabaseRule h2DatabaseRule = this.db;
        Intrinsics.checkExpressionValueIsNotNull((Object)h2DatabaseRule, (String)"db");
        Jdbi jdbi = h2DatabaseRule.getJdbi();
        Intrinsics.checkExpressionValueIsNotNull((Object)jdbi, (String)"db.jdbi");
        Jdbi $receiver$iv = jdbi;
        Object object = $receiver$iv.onDemand(ThingDao.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.onDemand(T::class.java)");
        ThingDao dao = (ThingDao)object;
        Thing brian = new Thing(1, "Brian", null, null, null, null, 56, null);
        Thing found = dao.insertAndFind(brian);
        AssertionsKt.assertEquals$default((Object)brian, (Object)found, null, (int)4, null);
    }

    @Test
    public final void testDefaultMethodShouldPropagateException() {
        H2DatabaseRule h2DatabaseRule = this.db;
        Intrinsics.checkExpressionValueIsNotNull((Object)h2DatabaseRule, (String)"db");
        Jdbi jdbi = h2DatabaseRule.getJdbi();
        Intrinsics.checkExpressionValueIsNotNull((Object)jdbi, (String)"db.jdbi");
        Jdbi $receiver$iv = jdbi;
        Object object = $receiver$iv.onDemand(ThingDao.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.onDemand(T::class.java)");
        ThingDao dao = (ThingDao)object;
        UnsupportedOperationException exception = new UnsupportedOperationException("Testing exception propagation");
        Throwable actualException2 = AssertionsKt.assertFails((Function0)((Function0)new Function0<Unit>(dao, exception){
            final /* synthetic */ ThingDao $dao;
            final /* synthetic */ UnsupportedOperationException $exception;

            public final void invoke() {
                this.$dao.throwsException(this.$exception);
            }
            {
                this.$dao = thingDao;
                this.$exception = unsupportedOperationException;
                super(0);
            }
        }));
        AssertionsKt.assertEquals$default((Object)exception, (Object)actualException2, null, (int)4, null);
    }

    @Test
    public final void qualifiedBindParameter() {
        H2DatabaseRule h2DatabaseRule = this.db;
        Intrinsics.checkExpressionValueIsNotNull((Object)h2DatabaseRule, (String)"db");
        Jdbi jdbi = h2DatabaseRule.getJdbi();
        Intrinsics.checkExpressionValueIsNotNull((Object)jdbi, (String)"db.jdbi");
        Jdbi $receiver$iv = jdbi;
        Object object = $receiver$iv.onDemand(QualifiedDao.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.onDemand(T::class.java)");
        QualifiedDao dao = (QualifiedDao)object;
        dao.insert(1, "abc");
        H2DatabaseRule h2DatabaseRule2 = this.db;
        Intrinsics.checkExpressionValueIsNotNull((Object)h2DatabaseRule2, (String)"db");
        Query query = h2DatabaseRule2.getSharedHandle().select("SELECT name FROM something WHERE id = 1", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"db.sharedHandle\n        \u2026 something WHERE id = 1\")");
        $receiver$iv = (ResultBearing)query;
        ResultIterable resultIterable = $receiver$iv.mapTo(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)resultIterable, (String)"this.mapTo(T::class.java)");
        Assertions.assertThat((String)((String)resultIterable.findOnly())).isEqualTo("cba", new Object[0]);
        H2DatabaseRule h2DatabaseRule3 = this.db;
        Intrinsics.checkExpressionValueIsNotNull((Object)h2DatabaseRule3, (String)"db");
        h2DatabaseRule3.getSharedHandle().execute("insert into something (id, name) values (2, 'xyz')", new Object[0]);
        Assertions.assertThat((String)dao.select(2)).isEqualTo("zyx", new Object[0]);
    }

    @Test
    public final void testDataClassWithJdbiConstructor() {
        H2DatabaseRule h2DatabaseRule = this.db;
        Intrinsics.checkExpressionValueIsNotNull((Object)h2DatabaseRule, (String)"db");
        h2DatabaseRule.getSharedHandle().execute("CREATE TABLE bean (s varchar, i integer)", new Object[0]);
        H2DatabaseRule h2DatabaseRule2 = this.db;
        Intrinsics.checkExpressionValueIsNotNull((Object)h2DatabaseRule2, (String)"db");
        h2DatabaseRule2.getSharedHandle().execute("INSERT INTO bean VALUES('x', 2)", new Object[0]);
        H2DatabaseRule h2DatabaseRule3 = this.db;
        Intrinsics.checkExpressionValueIsNotNull((Object)h2DatabaseRule3, (String)"db");
        TestDao dao = (TestDao)h2DatabaseRule3.getJdbi().onDemand(TestDao.class);
        DataClassWithJdbiConstructor result = dao.findOne("x");
        Assertions.assertThat((String)result.getS()).isEqualTo("x", new Object[0]);
        Assertions.assertThat((int)result.getI()).isEqualTo(2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003JK\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$Thing;", "", "id", "", "name", "", "nullable", "nullableDefaultedNull", "nullableDefaultedNotNull", "defaulted", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDefaulted", "()Ljava/lang/String;", "getId", "()I", "getName", "getNullable", "getNullableDefaultedNotNull", "getNullableDefaultedNull", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "jdbi3-kotlin-sqlobject"})
    public static final class Thing {
        private final int id;
        @NotNull
        private final String name;
        @Nullable
        private final String nullable;
        @Nullable
        private final String nullableDefaultedNull;
        @Nullable
        private final String nullableDefaultedNotNull;
        @NotNull
        private final String defaulted;

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getNullable() {
            return this.nullable;
        }

        @Nullable
        public final String getNullableDefaultedNull() {
            return this.nullableDefaultedNull;
        }

        @Nullable
        public final String getNullableDefaultedNotNull() {
            return this.nullableDefaultedNotNull;
        }

        @NotNull
        public final String getDefaulted() {
            return this.defaulted;
        }

        public Thing(int id, @NotNull String name, @Nullable String nullable, @Nullable String nullableDefaultedNull, @Nullable String nullableDefaultedNotNull, @NotNull String defaulted) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)defaulted, (String)"defaulted");
            this.id = id;
            this.name = name;
            this.nullable = nullable;
            this.nullableDefaultedNull = nullableDefaultedNull;
            this.nullableDefaultedNotNull = nullableDefaultedNotNull;
            this.defaulted = defaulted;
        }

        public /* synthetic */ Thing(int n, String string, String string2, String string3, String string4, String string5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string3 = null;
            }
            if ((n2 & 0x10) != 0) {
                string4 = "not null";
            }
            if ((n2 & 0x20) != 0) {
                string5 = "default value";
            }
            this(n, string, string2, string3, string4, string5);
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final String component3() {
            return this.nullable;
        }

        @Nullable
        public final String component4() {
            return this.nullableDefaultedNull;
        }

        @Nullable
        public final String component5() {
            return this.nullableDefaultedNotNull;
        }

        @NotNull
        public final String component6() {
            return this.defaulted;
        }

        @NotNull
        public final Thing copy(int id, @NotNull String name, @Nullable String nullable, @Nullable String nullableDefaultedNull, @Nullable String nullableDefaultedNotNull, @NotNull String defaulted) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)defaulted, (String)"defaulted");
            return new Thing(id, name, nullable, nullableDefaultedNull, nullableDefaultedNotNull, defaulted);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Thing copy$default(Thing thing, int n, String string, String string2, String string3, String string4, String string5, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = thing.id;
            }
            if ((n2 & 2) != 0) {
                string = thing.name;
            }
            if ((n2 & 4) != 0) {
                string2 = thing.nullable;
            }
            if ((n2 & 8) != 0) {
                string3 = thing.nullableDefaultedNull;
            }
            if ((n2 & 0x10) != 0) {
                string4 = thing.nullableDefaultedNotNull;
            }
            if ((n2 & 0x20) != 0) {
                string5 = thing.defaulted;
            }
            return thing.copy(n, string, string2, string3, string4, string5);
        }

        public String toString() {
            return "Thing(id=" + this.id + ", name=" + this.name + ", nullable=" + this.nullable + ", nullableDefaultedNull=" + this.nullableDefaultedNull + ", nullableDefaultedNotNull=" + this.nullableDefaultedNotNull + ", defaulted=" + this.defaulted + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.nullable;
            String string3 = this.nullableDefaultedNull;
            String string4 = this.nullableDefaultedNotNull;
            String string5 = this.defaulted;
            return ((((Integer.hashCode(this.id) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Thing)) break block3;
                    Thing thing = (Thing)object;
                    if (!(this.id == thing.id) || !Intrinsics.areEqual((Object)this.name, (Object)thing.name) || !Intrinsics.areEqual((Object)this.nullable, (Object)thing.nullable) || !Intrinsics.areEqual((Object)this.nullableDefaultedNull, (Object)thing.nullableDefaultedNull) || !Intrinsics.areEqual((Object)this.nullableDefaultedNotNull, (Object)thing.nullableDefaultedNotNull) || !Intrinsics.areEqual((Object)this.defaulted, (Object)thing.defaulted)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H'J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\fH'J\u0014\u0010\u000e\u001a\u00020\u00032\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$ThingDao;", "Lorg/jdbi/v3/sqlobject/SqlObject;", "findById", "Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$Thing;", "id", "", "findByIdWithAlias", "insert", "", "something", "insertAndFind", "list", "", "listWithNulls", "throwsException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "jdbi3-kotlin-sqlobject"})
    public static interface ThingDao
    extends SqlObject {
        @SqlUpdate(value="insert into something (id, name) values (:something.id, :something.name)")
        public void insert(@NotNull Thing var1);

        @NotNull
        public List<Thing> list();

        @SqlQuery(value="select id, name, null as nullable, null as nullableDefaultedNull, null as nullableDefaultedNotNull, 'test' as defaulted from something")
        @NotNull
        public List<Thing> listWithNulls();

        @SqlQuery(value="select id, name from something where id=:id")
        @NotNull
        public Thing findById(int var1);

        @SqlQuery(value="select id as t_id, name as t_name from something where id=:id")
        @RegisterKotlinMapper(value=Thing.class, prefix="t")
        @NotNull
        public Thing findByIdWithAlias(int var1);

        @NotNull
        public Thing insertAndFind(@NotNull Thing var1);

        @NotNull
        public Thing throwsException(@NotNull Exception var1);

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=3)
        public static final class DefaultImpls {
            @NotNull
            public static List<Thing> list(ThingDao $this) {
                List list = $this.getHandle().createQuery("select id, name from something").mapTo(Thing.class).list();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"handle.createQuery(\"sele\u2026                  .list()");
                return list;
            }

            @NotNull
            public static Thing insertAndFind(ThingDao $this, @NotNull Thing something) {
                Intrinsics.checkParameterIsNotNull((Object)something, (String)"something");
                $this.insert(something);
                return $this.findById(something.getId());
            }

            @NotNull
            public static Thing throwsException(ThingDao $this, @NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                throw (Throwable)e;
            }
        }
    }

    @RegisterArgumentFactory(value=ReversedStringArgumentFactory.class)
    @RegisterColumnMapper(value=ReversedStringMapper.class)
    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H'\u00a8\u0006\t"}, d2={"Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$QualifiedDao;", "", "insert", "", "id", "", "name", "", "select", "jdbi3-kotlin-sqlobject"})
    public static interface QualifiedDao {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(int var1, @Reversed @NotNull String var2);

        @SqlQuery(value="select name from something where id = :id")
        @Reversed
        @NotNull
        public String select(int var1);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$DataClassWithJdbiConstructor;", "", "s", "", "i", "", "(Ljava/lang/String;I)V", "getI", "()I", "getS", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "jdbi3-kotlin-sqlobject"})
    public static final class DataClassWithJdbiConstructor {
        @NotNull
        private final String s;
        private final int i;

        @NotNull
        public final String getS() {
            return this.s;
        }

        public final int getI() {
            return this.i;
        }

        @JdbiConstructor
        public DataClassWithJdbiConstructor(@ColumnName(value="not_s") @NotNull String s, @ColumnName(value="i") int i) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            this.s = s;
            this.i = i;
        }

        @JdbiConstructor
        public /* synthetic */ DataClassWithJdbiConstructor(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 5;
            }
            this(string, n);
        }

        @NotNull
        public final String component1() {
            return this.s;
        }

        public final int component2() {
            return this.i;
        }

        @NotNull
        public final DataClassWithJdbiConstructor copy(@ColumnName(value="not_s") @NotNull String s, @ColumnName(value="i") int i) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            return new DataClassWithJdbiConstructor(s, i);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ DataClassWithJdbiConstructor copy$default(DataClassWithJdbiConstructor dataClassWithJdbiConstructor, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = dataClassWithJdbiConstructor.s;
            }
            if ((n2 & 2) != 0) {
                n = dataClassWithJdbiConstructor.i;
            }
            return dataClassWithJdbiConstructor.copy(string, n);
        }

        public String toString() {
            return "DataClassWithJdbiConstructor(s=" + this.s + ", i=" + this.i + ")";
        }

        public int hashCode() {
            String string = this.s;
            return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.i);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DataClassWithJdbiConstructor)) break block3;
                    DataClassWithJdbiConstructor dataClassWithJdbiConstructor = (DataClassWithJdbiConstructor)object;
                    if (!Intrinsics.areEqual((Object)this.s, (Object)dataClassWithJdbiConstructor.s) || !(this.i == dataClassWithJdbiConstructor.i)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u00a8\u0006\u0006"}, d2={"Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$TestDao;", "", "findOne", "Lorg/jdbi/v3/kotlin/KotlinSqlObjectPluginTest$DataClassWithJdbiConstructor;", "s", "", "jdbi3-kotlin-sqlobject"})
    public static interface TestDao {
        @SqlQuery(value="SELECT s as not_s, i as i from bean where s = :s")
        @RegisterConstructorMappers(value={@RegisterConstructorMapper(value=DataClassWithJdbiConstructor.class)})
        @NotNull
        public DataClassWithJdbiConstructor findOne(@NotNull String var1);
    }
}

