/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.json.AbstractJsonMapperTest;
import org.jdbi.v3.json.Json;
import org.jdbi.v3.moshi.MoshiConfig;
import org.jdbi.v3.moshi.MoshiPlugin;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestMoshiPlugin
extends AbstractJsonMapperTest {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugins(new JdbiPlugin[]{new SqlObjectPlugin(), new PostgresPlugin(), new MoshiPlugin()});

    @BeforeEach
    public void before() {
        this.jdbi = (Jdbi)this.pgExtension.getJdbi().installPlugin((JdbiPlugin)new MoshiPlugin()).configure(MoshiConfig.class, c -> c.setMoshi(new Moshi.Builder().add((JsonAdapter.Factory)new OptionalAdapter()).build()));
    }

    @Test
    public void typeCanBeOverridden() {
        this.pgExtension.getJdbi().useHandle(h -> {
            h.createUpdate("create table users(usr json)").execute();
            Moshi moshi = new Moshi.Builder().add((JsonAdapter.Factory)new OptionalAdapter()).add(SuperUser.class, (JsonAdapter)new SuperUserAdapter()).add(SubUser.class, (JsonAdapter)new SubUserAdapter()).build();
            ((MoshiConfig)h.getConfig(MoshiConfig.class)).setMoshi(moshi);
            ((Update)h.createUpdate("insert into users(usr) values(:user)").bindByType("user", (Object)new SubUser(), QualifiedType.of(SuperUser.class).with(new Class[]{Json.class}))).execute();
            User subuser = (User)h.createQuery("select usr from users").mapTo(QualifiedType.of(User.class).with(new Class[]{Json.class})).one();
            ((AbstractStringAssert)Assertions.assertThat((String)subuser.name).describedAs("instead of being bound via getClass(), the object was bound according to the qualified type param", new Object[0])).isEqualTo("super");
        });
    }

    private static class OptionalAdapter
    implements JsonAdapter.Factory {
        private OptionalAdapter() {
        }

        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            Class rawType = Types.getRawType((Type)type);
            if (rawType == Optional.class && type instanceof ParameterizedType) {
                final JsonAdapter delegate = moshi.adapter(((ParameterizedType)type).getActualTypeArguments()[0]);
                return new JsonAdapter<Optional<Object>>(){

                    public Optional<Object> fromJson(JsonReader reader) throws IOException {
                        if (reader.peek() == JsonReader.Token.NULL) {
                            return Optional.ofNullable(reader.nextNull());
                        }
                        return Optional.of(delegate.fromJson(reader));
                    }

                    public void toJson(JsonWriter writer, Optional<Object> value) throws IOException {
                        if (value != null && value.isPresent()) {
                            delegate.toJson(writer, value.get());
                        } else {
                            writer.nullValue();
                        }
                    }
                };
            }
            return null;
        }
    }

    private static class SuperUser {
        private SuperUser() {
        }
    }

    private static class SuperUserAdapter
    extends JsonAdapter<SuperUser> {
        private SuperUserAdapter() {
        }

        public void toJson(JsonWriter out, SuperUser superUser) throws IOException {
            out.beginObject().name("name").value("super").endObject();
        }

        public SuperUser fromJson(JsonReader in) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SubUser
    extends SuperUser {
        private SubUser() {
        }
    }

    private static class SubUserAdapter
    extends JsonAdapter<SubUser> {
        private SubUserAdapter() {
        }

        public void toJson(JsonWriter out, SubUser subUser) throws IOException {
            out.beginObject().name("name").value("sub").endObject();
        }

        public SubUser fromJson(JsonReader in) {
            throw new UnsupportedOperationException();
        }
    }

    public static class User {
        private final String name;

        public User(String name) {
            this.name = name;
        }
    }
}

