/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.argument.ObjectArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

@ConfiguringAnnotation(value=Impl.class)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RegisterObjectArgumentFactory {
    public Class<?>[] value();

    public int[] sqlType() default {};

    public static class Impl
    implements Configurer {
        @Override
        public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
            RegisterObjectArgumentFactory registerObjectArgumentFactory = (RegisterObjectArgumentFactory)annotation;
            Arguments arguments = (Arguments)registry.get(Arguments.class);
            Class<?>[] classes = registerObjectArgumentFactory.value();
            int[] sqlTypes = registerObjectArgumentFactory.sqlType();
            if (sqlTypes.length != 0 && sqlTypes.length != classes.length) {
                throw new IllegalStateException("RegisterObjectArgumentFactory.sqlTypes() must have the same number of elements as value()");
            }
            for (int i = 0; i < classes.length; ++i) {
                Class<?> clazz = classes[i];
                Integer sqlType = sqlTypes.length == 0 ? null : Integer.valueOf(sqlTypes[i]);
                arguments.register(ObjectArgumentFactory.create(clazz, (Integer)sqlType));
            }
        }

        @Override
        public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
            this.configureForType(registry, annotation, sqlObjectType);
        }
    }
}

