/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.context;

import org.jdklog.logging.api.context.StudyContext;
import org.jdklog.logging.api.exception.StudyJuliRuntimeException;
import org.jdklog.logging.api.worker.StudyWorker;
import org.jdklog.logging.core.context.StudyThreadImpl;

public abstract class AbstractStudyContext
implements StudyContext {
    public final <T> void dispatch(T event, StudyWorker<T> handler) {
        try {
            this.beginDispatch();
            handler.handle(event);
        }
        catch (Exception e) {
            throw new StudyJuliRuntimeException((Throwable)e);
        }
        finally {
            this.endDispatch();
        }
    }

    public final void dispatch(Runnable handler) {
        try {
            this.beginDispatch();
            handler.run();
        }
        catch (Exception e) {
            throw new StudyJuliRuntimeException((Throwable)e);
        }
        finally {
            this.endDispatch();
        }
    }

    public final void beginDispatch() {
        Thread thread = Thread.currentThread();
        if (thread instanceof StudyThreadImpl) {
            StudyThreadImpl th = (StudyThreadImpl)((Object)thread);
            th.beginEmission(this);
        }
    }

    public final void endDispatch() {
        Thread thread = Thread.currentThread();
        if (thread instanceof StudyThreadImpl) {
            StudyThreadImpl th = (StudyThreadImpl)((Object)thread);
            th.endEmission();
        }
    }

    public final <T> void dispatchV2(String unique, T event, StudyWorker<T> handler) {
        try {
            this.beginDispatchV2(unique);
            handler.handle(event);
        }
        catch (Exception e) {
            throw new StudyJuliRuntimeException((Throwable)e);
        }
        finally {
            this.endDispatchV2();
        }
    }

    public final void beginDispatchV2(String unique) {
        Thread thread = Thread.currentThread();
        if (thread instanceof StudyThreadImpl) {
            StudyThreadImpl th = (StudyThreadImpl)((Object)thread);
            th.beginEmissionV2(unique, this);
        }
    }

    public final void endDispatchV2() {
        Thread thread = Thread.currentThread();
        if (thread instanceof StudyThreadImpl) {
            StudyThreadImpl th = (StudyThreadImpl)((Object)thread);
            th.endEmissionV2();
        }
    }

    abstract <T> void runAsContext(StudyWorker<T> var1);
}

