/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.context;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jdklog.logging.api.context.StudyContext;
import org.jdklog.logging.core.context.StudyThreadImpl;

public final class StudyThread
extends Thread
implements StudyThreadImpl {
    private final int threadType;
    private final long maxExecTime;
    private final TimeUnit maxExecTimeUnit;
    private long execStart;
    private StudyContext context;
    private String unique;

    public StudyThread(Runnable targetParam, String nameParam, int threadTypeParam, long maxExecTimeParam, TimeUnit maxExecTimeUnitParam) {
        super(targetParam, nameParam);
        this.threadType = threadTypeParam;
        this.maxExecTime = maxExecTimeParam;
        this.maxExecTimeUnit = maxExecTimeUnitParam;
    }

    @Override
    public TimeUnit maxExecTimeUnit() {
        return this.maxExecTimeUnit;
    }

    @Override
    public int threadType() {
        return this.threadType;
    }

    @Override
    public long startTime() {
        return this.execStart;
    }

    @Override
    public long maxExecTime() {
        return this.maxExecTime;
    }

    StudyContext context() {
        return this.context;
    }

    @Override
    public String getUnique() {
        return this.unique;
    }

    @Override
    public void setUnique(String unique) {
        this.unique = unique;
    }

    private void executeStart() {
        if (null == this.context) {
            this.execStart = System.currentTimeMillis();
            this.unique = UUID.randomUUID().toString();
        }
    }

    private void executeEnd() {
        if (null == this.context) {
            this.execStart = 0L;
            this.unique = null;
        }
    }

    @Override
    public void beginEmission(StudyContext contextParam) {
        this.executeStart();
        this.context = contextParam;
    }

    @Override
    public void endEmission() {
        this.context = null;
        this.executeEnd();
    }

    private void executeStartV2(String uniqueParam) {
        if (null == this.context) {
            this.execStart = System.currentTimeMillis();
            this.unique = uniqueParam;
        }
    }

    private void executeEndV2() {
        if (null == this.context) {
            this.execStart = 0L;
            this.unique = null;
        }
    }

    @Override
    public void beginEmissionV2(String uniqueParam, StudyContext contextParam) {
        this.executeStartV2(uniqueParam);
        this.context = contextParam;
    }

    @Override
    public void endEmissionV2() {
        this.context = null;
        this.executeEndV2();
    }
}

