/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.context;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jdklog.logging.api.monitor.Monitor;
import org.jdklog.logging.core.context.StudyThread;

public class StudyThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final Monitor checker;
    private final int threadType;
    private final long maxExecTime;
    private final TimeUnit maxExecTimeUnit;

    public StudyThreadFactory(String prefixParam, Monitor checkerParam) {
        this.prefix = prefixParam;
        this.checker = checkerParam;
        this.threadType = 0;
        this.maxExecTime = 10000L;
        this.maxExecTimeUnit = TimeUnit.MILLISECONDS;
    }

    public StudyThreadFactory(String prefixParam, Monitor checkerParam, int threadTypeParam, long maxExecTimeParam, TimeUnit maxExecTimeUnitParam) {
        this.prefix = prefixParam;
        this.checker = checkerParam;
        this.threadType = threadTypeParam;
        this.maxExecTime = maxExecTimeParam;
        this.maxExecTimeUnit = maxExecTimeUnitParam;
    }

    @Override
    public final Thread newThread(Runnable runnable) {
        int andIncrement = this.threadCount.getAndIncrement();
        StudyThread studyThread = new StudyThread(runnable, this.prefix + andIncrement, this.threadType, this.maxExecTime, this.maxExecTimeUnit);
        if (null != this.checker) {
            this.checker.registerThread((Thread)studyThread);
        }
        studyThread.setDaemon(true);
        return studyThread;
    }
}

