/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.context;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.jdklog.logging.api.context.WorkerContext;
import org.jdklog.logging.api.worker.StudyWorker;
import org.jdklog.logging.core.context.AbstractStudyContext;

public class WorkerStudyContextImpl
extends AbstractStudyContext
implements WorkerContext {
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;

    public WorkerStudyContextImpl(ExecutorService executorService, ScheduledExecutorService scheduledExecutorService) {
        this.executorService = executorService;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public final void executeInExecutorService(Runnable task) {
        this.executorService.execute(task);
    }

    public final <T> void executeInExecutorService(T event, StudyWorker<T> handler) {
        Runnable task = () -> this.dispatch(event, handler);
        this.executorService.submit(task);
    }

    public final ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public final <T> void executeInExecutorServiceV2(String unique, T event, StudyWorker<T> handler) {
        Runnable task = () -> this.dispatchV2(unique, event, handler);
        this.executorService.submit(task);
    }

    @Override
    <T> void runAsContext(StudyWorker<T> handler) {
    }
}

