/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.factory;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.jdklog.logging.api.handler.Handler;
import org.jdklog.logging.api.logger.Logger;
import org.jdklog.logging.api.metainfo.Level;
import org.jdklog.logging.api.metainfo.LogLevel;
import org.jdklog.logging.api.metainfo.LogRecord;
import org.jdklog.logging.api.metainfo.Record;
import org.jdklog.logging.api.spi.Log;
import org.jdklog.logging.core.context.StudyThreadImpl;
import org.jdklog.logging.core.formatter.StudyJuliMessageFormat;
import org.jdklog.logging.core.manager.JuliLogger;
import org.jdklog.logging.core.manager.LogManagerUtils;

public class JuliLog
implements Log {
    private static final AtomicLong GLOBAL_COUNTER = new AtomicLong(0L);
    private final Logger logger;
    private StackTraceElement stackTraceElement;

    public JuliLog() {
        String name = JuliLog.class.getName();
        this.logger = JuliLogger.getLogger(name);
    }

    public JuliLog(String name) {
        this.logger = JuliLogger.getLogger(name);
    }

    private void log(Level logLevel, String message, Throwable throwable) {
        Thread thread;
        LogRecord lr = new LogRecord(logLevel, message);
        if (null == this.stackTraceElement) {
            Throwable stackTrace = new Throwable();
            StackTraceElement[] stackTraceElements = stackTrace.getStackTrace();
            this.stackTraceElement = stackTraceElements[3];
        }
        lr.setThrown(throwable);
        String className = this.logger.getName();
        String classMethod = this.stackTraceElement.getMethodName();
        lr.setSourceClassName(className);
        lr.setSourceMethodName(classMethod);
        int lineNumber = this.stackTraceElement.getLineNumber();
        lr.setLineNumber(lineNumber);
        String unique = LogManagerUtils.getProperty(".unique", "false");
        if ("true".equals(unique) && (thread = Thread.currentThread()) instanceof StudyThreadImpl) {
            StudyThreadImpl studyThread = (StudyThreadImpl)((Object)thread);
            String uniqueStr = studyThread.getUnique();
            lr.setUniqueId(uniqueStr);
        }
        long globalCounter = GLOBAL_COUNTER.incrementAndGet();
        lr.setSerialNumber(globalCounter);
        String host = LogManagerUtils.getProperty(".host", null);
        lr.setHost(host);
        String port = LogManagerUtils.getProperty(".port", null);
        lr.setPort(port);
        this.logger.logp((Record)lr);
    }

    private void logCore(Level logLevel, String message) {
        this.log(logLevel, message, null);
    }

    private void logCore(Level logLevel, String message, Object ... args) {
        boolean isIndex;
        Objects.requireNonNull(message, "\u65e5\u5fd7\u6d88\u606f\u4e0d\u80fd\u4e3a\u7a7a.");
        Objects.requireNonNull(args, "\u65e5\u5fd7\u6d88\u606f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        int argsLen = args.length;
        int index = message.indexOf("{}");
        boolean isLen = 0 == args.length;
        boolean bl = isIndex = -1 == index;
        if (isLen || isIndex) {
            this.log(logLevel, message, null);
        } else {
            int lastArrIdx = argsLen - 1;
            Object lastEntry = args[lastArrIdx];
            Throwable throwable = null;
            if (lastEntry instanceof Throwable) {
                throwable = (Throwable)lastEntry;
            }
            String messageFormat = StudyJuliMessageFormat.format(message, args);
            this.log(logLevel, messageFormat, throwable);
        }
    }

    public final void addHandler(Handler handler) {
        Objects.requireNonNull(handler);
        this.logger.addHandler(handler);
    }

    public final void setLevel(Level newLogLevel) {
        this.logger.setLevel(newLogLevel);
    }

    public final void info(String message, Object ... args) {
        this.logCore(LogLevel.INFO, message, args);
    }

    public final void info(String message) {
        this.logCore(LogLevel.OFF, message);
    }

    public final void debug(String message, Object ... args) {
        this.logCore(LogLevel.FINE, message, args);
    }

    public final void debug(String message) {
        this.logCore(LogLevel.OFF, message);
    }

    public final void trace(String message, Object ... args) {
        this.logCore(LogLevel.FINER, message, args);
    }

    public final void trace(String message) {
        this.logCore(LogLevel.OFF, message);
    }

    public final void warn(String message, Object ... args) {
        this.logCore(LogLevel.WARNING, message, args);
    }

    public final void warn(String message) {
        this.logCore(LogLevel.OFF, message);
    }

    public final void error(String message, Object ... args) {
        this.logCore(LogLevel.SEVERE, message, args);
    }

    public final void error(String message) {
        this.logCore(LogLevel.OFF, message);
    }

    public final void fatal(String message, Object ... args) {
        this.logCore(LogLevel.SEVERE, message, args);
    }

    public final void fatal(String message) {
        this.logCore(LogLevel.OFF, message);
    }

    public final void config(String message) {
        this.logCore(LogLevel.CONFIG, message);
    }

    public final void config(String message, Object ... args) {
        this.logCore(LogLevel.CONFIG, message, args);
    }

    public final void all(String message) {
        this.logCore(LogLevel.ALL, message);
    }

    public final void all(String message, Object ... args) {
        this.logCore(LogLevel.ALL, message, args);
    }

    public final void off(String message) {
        this.logCore(LogLevel.OFF, message);
    }

    public final void off(String message, Object ... args) {
        this.logCore(LogLevel.OFF, message, args);
    }
}

