/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.factory;

import java.lang.reflect.Constructor;
import java.nio.file.FileSystems;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import org.jdklog.logging.api.exception.StudyJuliConfigException;
import org.jdklog.logging.api.factory.Factory;
import org.jdklog.logging.api.spi.Log;
import org.jdklog.logging.core.factory.JuliLog;

public final class LogFactory
implements Factory {
    private static final Factory SINGLETON = new LogFactory();
    private Constructor<? extends Log> spiConstructor;

    private LogFactory() {
        try {
            FileSystems.getDefault();
            this.serviceLoad();
        }
        catch (Exception e) {
            throw new StudyJuliConfigException((Throwable)e);
        }
    }

    public static Log getLog(Class<?> clazz) {
        String name = clazz.getName();
        return SINGLETON.getInstance(name);
    }

    public static Log getLog(String name) {
        return SINGLETON.getInstance(name);
    }

    private void serviceLoad() throws NoSuchMethodException {
        ServiceLoader<Log> logLoader = ServiceLoader.load(Log.class);
        Iterator<Log> iterator = logLoader.iterator();
        if (iterator.hasNext()) {
            Optional<Log> first = logLoader.findFirst();
            if (first.isPresent()) {
                Log log = first.get();
                Class<?> logClass = log.getClass();
                this.spiConstructor = logClass.getConstructor(String.class);
            }
        } else {
            this.spiConstructor = JuliLog.class.getConstructor(String.class);
            StudyJuliConfigException exception = new StudyJuliConfigException("SPI\u670d\u52a1\u6ca1\u6709\u8bfb\u53d6\u5230\u4efb\u4f55\u5b9e\u73b0,\u8c03\u8bd5\u67e5\u770bBuiltinClassLoader\u7c7b1045\u884ccheckURL\u65b9\u6cd5.");
            exception.printStackTrace();
        }
    }

    public Log getInstance(String name) {
        try {
            return this.spiConstructor.newInstance(name);
        }
        catch (Exception e) {
            throw new StudyJuliConfigException((Throwable)e);
        }
    }

    public String toString() {
        return "LogFactory{spiConstructor=" + this.spiConstructor + "}";
    }
}

