/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.formatter;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import org.jdklog.logging.api.metainfo.Record;
import org.jdklog.logging.core.formatter.AbstractMessageFormatter;
import org.jdklog.logging.core.manager.AbstractLogManager;

public final class StudyJuliMessageJsonFormatter
extends AbstractMessageFormatter {
    private final DateTimeFormatter pattern;

    public StudyJuliMessageJsonFormatter() {
        String name = StudyJuliMessageJsonFormatter.class.getName();
        String timeFormat = AbstractLogManager.getProperty1(name + ".dateTimeFormat");
        if (Objects.isNull(timeFormat)) {
            timeFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
        }
        this.pattern = DateTimeFormatter.ofPattern(timeFormat);
    }

    public StudyJuliMessageJsonFormatter(String timeFormat) {
        this.pattern = Objects.isNull(timeFormat) ? DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ") : DateTimeFormatter.ofPattern(timeFormat);
    }

    public String format(Record logRecord) {
        Instant instant = logRecord.getInstant();
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
        String format = this.pattern.format(zdt);
        StringBuilder sb = new StringBuilder(50);
        String timestamp = StudyJuliMessageJsonFormatter.inQuotes("timestamp");
        String formatStr = StudyJuliMessageJsonFormatter.inQuotes(format);
        sb.append('{').append(timestamp).append(": ").append(formatStr).append(',');
        String level = StudyJuliMessageJsonFormatter.inQuotes("level");
        String levelName = logRecord.getLevelName();
        String levelNameStr = StudyJuliMessageJsonFormatter.inQuotes(levelName);
        sb.append(level).append(": ").append(levelNameStr).append(',');
        String threadKey = StudyJuliMessageJsonFormatter.inQuotes("thread");
        Thread thread = Thread.currentThread();
        String name = thread.getName();
        String threadName = StudyJuliMessageJsonFormatter.inQuotes(name);
        sb.append(threadKey).append(": ").append(threadName).append(',');
        String fullClassPath = StudyJuliMessageJsonFormatter.inQuotes("fullClassPath");
        String sourceClassName = logRecord.getSourceClassName();
        String sourceClassNameStr = StudyJuliMessageJsonFormatter.inQuotes(sourceClassName);
        sb.append(fullClassPath).append(": ").append(sourceClassNameStr).append(',');
        String methodKey = StudyJuliMessageJsonFormatter.inQuotes("method");
        String methodStr = logRecord.getSourceMethodName();
        String methodValue = StudyJuliMessageJsonFormatter.inQuotes(methodStr);
        sb.append(methodKey).append(": ").append(methodValue).append(',');
        String lineNumberKey = StudyJuliMessageJsonFormatter.inQuotes("lineNumber");
        int lineNumber = logRecord.getLineNumber();
        String lineNumberStr = String.valueOf(lineNumber);
        String lineNumberValue = StudyJuliMessageJsonFormatter.inQuotes(lineNumberStr);
        sb.append(lineNumberKey).append(": ").append(lineNumberValue).append(',');
        if (StudyJuliMessageJsonFormatter.checkUnique()) {
            String uniqueIdKey = StudyJuliMessageJsonFormatter.inQuotes("uniqueId");
            String uniqueIdStr = logRecord.getUniqueId();
            String uniqueIdValue = StudyJuliMessageJsonFormatter.inQuotes(uniqueIdStr);
            sb.append(uniqueIdKey).append(": ").append(uniqueIdValue).append(',');
        }
        String serialNumberKey = StudyJuliMessageJsonFormatter.inQuotes("serialNumber");
        long serialNumber = logRecord.getSerialNumber();
        sb.append(serialNumberKey).append(": ").append(serialNumber).append(',');
        Map customs = logRecord.getCustoms();
        for (Map.Entry entry : customs.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String customKey = StudyJuliMessageJsonFormatter.inQuotes(key);
            sb.append(customKey).append(": ");
            String customValue = StudyJuliMessageJsonFormatter.inQuotes(value);
            sb.append(customValue);
            sb.append(',');
        }
        String message = StudyJuliMessageJsonFormatter.defaultFormat(logRecord);
        String messageKey = StudyJuliMessageJsonFormatter.inQuotes("message");
        String messageValue = StudyJuliMessageJsonFormatter.inQuotes(message);
        sb.append(messageKey).append(": ").append(messageValue);
        Throwable thrown = logRecord.getThrown();
        if (null != thrown) {
            StackTraceElement[] stackTraceElements;
            String stacktrace = StudyJuliMessageJsonFormatter.inQuotes("stacktrace");
            String thrownStr = thrown.toString();
            String thrownStr2 = StudyJuliMessageJsonFormatter.inQuotes(thrownStr);
            sb.append(',').append(stacktrace).append(": ").append('[').append(thrownStr2).append(',');
            String separator = "";
            for (StackTraceElement stackTraceElement : stackTraceElements = thrown.getStackTrace()) {
                String stackTraceElementStr = stackTraceElement.toString();
                String stackTraceElementStr2 = StudyJuliMessageJsonFormatter.inQuotes(stackTraceElementStr);
                sb.append(separator).append(stackTraceElementStr2);
                separator = ",";
            }
            sb.append(']');
        }
        String lineSeparator = System.lineSeparator();
        sb.append('}').append(lineSeparator);
        return sb.toString();
    }

    private static String inQuotes(String s) {
        return "\"" + s + "\"";
    }
}

