/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.formatter;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import org.jdklog.logging.api.metainfo.Record;
import org.jdklog.logging.core.formatter.AbstractMessageFormatter;
import org.jdklog.logging.core.manager.AbstractLogManager;
import org.jdklog.logging.core.manager.LogManagerUtils;

public final class StudyJuliMessageTextFormatter
extends AbstractMessageFormatter {
    private final DateTimeFormatter pattern;

    public StudyJuliMessageTextFormatter() {
        String name = StudyJuliMessageTextFormatter.class.getName();
        String timeFormat = AbstractLogManager.getProperty1(name + ".dateTimeFormat");
        if (Objects.isNull(timeFormat)) {
            timeFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
        }
        this.pattern = DateTimeFormatter.ofPattern(timeFormat);
    }

    public StudyJuliMessageTextFormatter(String timeFormat) {
        this.pattern = Objects.isNull(timeFormat) ? DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ") : DateTimeFormatter.ofPattern(timeFormat);
    }

    public String format(Record logRecord) {
        String port;
        Instant instant = logRecord.getInstant();
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
        String format = this.pattern.format(zdt);
        StringBuilder sb = new StringBuilder(16);
        sb.append(format);
        sb.append(' ');
        String levelName = logRecord.getLevelName();
        sb.append(levelName);
        sb.append(' ');
        sb.append('[');
        Thread thread = Thread.currentThread();
        String name = thread.getName();
        sb.append(name);
        sb.append(']');
        sb.append(' ');
        String sourceClassName = logRecord.getSourceClassName();
        sb.append(sourceClassName);
        sb.append(' ');
        String sourceMethodName = logRecord.getSourceMethodName();
        sb.append(sourceMethodName);
        sb.append(' ');
        int lineNumber = logRecord.getLineNumber();
        sb.append(lineNumber);
        sb.append(' ');
        String unique = LogManagerUtils.getProperty(".unique", "false");
        if (unique.equals("true")) {
            String uniqueId = logRecord.getUniqueId();
            sb.append(uniqueId);
            sb.append(' ');
        }
        long serialNumber = logRecord.getSerialNumber();
        sb.append(serialNumber);
        sb.append(' ');
        String host = logRecord.getHost();
        if (Objects.nonNull(host)) {
            sb.append(host);
            sb.append(' ');
        }
        if (Objects.nonNull(port = logRecord.getPort())) {
            sb.append(port);
            sb.append(' ');
        }
        Map customs = logRecord.getCustoms();
        for (Map.Entry entry : customs.entrySet()) {
            String value = (String)entry.getValue();
            sb.append(value);
            sb.append(' ');
        }
        String message = StudyJuliMessageTextFormatter.defaultFormat(logRecord);
        sb.append(message);
        Throwable thrown = logRecord.getThrown();
        if (null != thrown) {
            StackTraceElement[] stackTraceElements;
            sb.append(' ');
            sb.append('[');
            sb.append(thrown);
            sb.append(',');
            String separator = "";
            for (StackTraceElement stackTraceElement : stackTraceElements = thrown.getStackTrace()) {
                sb.append(separator);
                sb.append(stackTraceElement);
                separator = ",";
            }
            sb.append(']');
        }
        String lineSeparator = System.lineSeparator();
        sb.append(lineSeparator);
        return sb.toString();
    }
}

