/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.handler;

import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jdklog.logging.api.context.WorkerContext;
import org.jdklog.logging.api.filter.Filter;
import org.jdklog.logging.api.formatter.Formatter;
import org.jdklog.logging.api.handler.Handler;
import org.jdklog.logging.api.metainfo.Level;
import org.jdklog.logging.api.metainfo.LogLevel;
import org.jdklog.logging.api.metainfo.Record;
import org.jdklog.logging.api.monitor.Monitor;
import org.jdklog.logging.api.queue.StudyQueue;
import org.jdklog.logging.api.worker.StudyWorker;
import org.jdklog.logging.core.context.StudyThreadFactory;
import org.jdklog.logging.core.context.WorkerStudyContextImpl;
import org.jdklog.logging.core.handler.GuardianConsumerMonitor;
import org.jdklog.logging.core.handler.ProducerNoticeConsumerWorker;
import org.jdklog.logging.core.handler.StudyRejectedPolicy;
import org.jdklog.logging.core.handler.ThreadMonitor;
import org.jdklog.logging.core.manager.AbstractLogManager;
import org.jdklog.logging.core.queue.EventQueue;

public abstract class AbstractHandler
implements Handler {
    private static final Monitor CHECKER = new ThreadMonitor(15000L);
    private static final Monitor GUARDIAN = new GuardianConsumerMonitor();
    private static final ExecutorService LOG_PRODUCER = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5000), new StudyThreadFactory("log-producer", CHECKER), new StudyRejectedPolicy());
    private static final ExecutorService LOG_GUARDIAN_CONSUMER = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5000), new StudyThreadFactory("log-guardian-consumer", CHECKER), new StudyRejectedPolicy());
    private static final ExecutorService LOG_CONSUMER = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5000), new StudyThreadFactory("log-consumer", CHECKER), new StudyRejectedPolicy());
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(3, new StudyThreadFactory("study_scheduled", null));
    protected static final WorkerContext LOG_PRODUCER_CONTEXT = new WorkerStudyContextImpl(LOG_PRODUCER, SCHEDULED_EXECUTOR_SERVICE);
    protected static final WorkerContext LOG_CONSUMER_CONTEXT = new WorkerStudyContextImpl(LOG_CONSUMER, SCHEDULED_EXECUTOR_SERVICE);
    private static final WorkerContext LOG_GUARDIAN_CONSUMER_CONTEXT = new WorkerStudyContextImpl(LOG_GUARDIAN_CONSUMER, SCHEDULED_EXECUTOR_SERVICE);
    private static final ExecutorService LOG_PRODUCER_NOTICE_CONSUMER = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5000), new StudyThreadFactory("log-producer-notice-consumer", CHECKER), new StudyRejectedPolicy());
    protected static final WorkerContext LOG_PRODUCER_NOTICE_CONSUMER_CONTEXT = new WorkerStudyContextImpl(LOG_PRODUCER_NOTICE_CONSUMER, SCHEDULED_EXECUTOR_SERVICE);
    private static final int OFF_VALUE = LogLevel.OFF.intValue();
    protected static final AtomicLong GLOBAL_COUNTER = new AtomicLong(0L);
    protected static final StudyQueue<String> EVENT_QUEUE = new EventQueue("EventQueue");
    protected final AtomicLong counter = new AtomicLong(0L);
    protected final StudyWorker<Handler> producerNoticeConsumerWorker = new ProducerNoticeConsumerWorker();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(false);
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    protected long sys;
    protected long initialization;
    protected int interval;
    protected DateTimeFormatter intervalFormatter;
    protected boolean rotatable = true;
    protected Filter filter;
    protected Formatter formatter;
    protected Level logLevel = LogLevel.ALL;
    private String encoding;

    public final void close() {
        LOG_CONSUMER.shutdown();
        LOG_PRODUCER.shutdown();
    }

    public final String getProperty(String name, String defaultValue) {
        String value = AbstractLogManager.getProperty1(name);
        value = null == value ? defaultValue : value.trim();
        return value;
    }

    public final long getSys() {
        return this.sys;
    }

    public final Formatter getFormatter() {
        return this.formatter;
    }

    public final void setFormatter(Formatter newFormatter) {
        this.formatter = Objects.requireNonNull(newFormatter);
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final Filter getFilter() {
        return this.filter;
    }

    public final void setFilter(Filter newFilter) {
        this.filter = newFilter;
    }

    public final Level getLevel() {
        return this.logLevel;
    }

    public final void setLevel(Level newLogLevel) {
        this.logLevel = newLogLevel;
    }

    public final boolean isLoggable(Record logRecord) {
        boolean offValue;
        int levelValue = this.logLevel.intValue();
        boolean intValue = logRecord.intValue() < levelValue;
        boolean bl = offValue = levelValue == OFF_VALUE;
        if (intValue || offValue) {
            return false;
        }
        boolean isFilter = null == this.filter;
        boolean isLoggable = !isFilter && this.filter.isLoggable(logRecord);
        return isFilter || isLoggable;
    }

    public final AtomicLong getCounter() {
        return this.counter;
    }

    static {
        CHECKER.monitor(LOG_PRODUCER_CONTEXT);
        CHECKER.monitor(LOG_CONSUMER_CONTEXT);
        GUARDIAN.monitor(LOG_GUARDIAN_CONSUMER_CONTEXT);
    }
}

