/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.handler;

import java.io.BufferedWriter;
import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.jdklog.logging.api.exception.StudyJuliRuntimeException;
import org.jdklog.logging.api.filter.Filter;
import org.jdklog.logging.api.formatter.Formatter;
import org.jdklog.logging.api.metainfo.Level;
import org.jdklog.logging.api.metainfo.LogLevel;
import org.jdklog.logging.api.metainfo.Record;
import org.jdklog.logging.api.queue.StudyQueue;
import org.jdklog.logging.api.worker.StudyWorker;
import org.jdklog.logging.core.handler.AbstractHandler;
import org.jdklog.logging.core.handler.ConsumerRunnable;
import org.jdklog.logging.core.queue.FileQueue;
import org.jdklog.logging.core.queue.ProducerWorker;
import org.jdklog.logging.core.utils.ClassLoadingUtils;

public class FileHandlerV2
extends AbstractHandler {
    private final Runnable consumerRunnable;
    private final StudyQueue<Record> fileQueue;
    private String suffix;
    private String prefix;
    private String directory;
    private BufferedWriter bufferedWriter;
    private File logFilePath;
    private final StudyWorker<Record> producerWorker;

    public FileHandlerV2() {
        this.config();
        this.fileQueue = new FileQueue(this.prefix);
        this.producerWorker = new ProducerWorker(this.fileQueue);
        this.consumerRunnable = new ConsumerRunnable(this.fileQueue, this);
        this.open();
    }

    public FileHandlerV2(String prefix) {
        this.prefix = prefix;
        this.config();
        this.fileQueue = new FileQueue(this.prefix);
        this.producerWorker = new ProducerWorker(this.fileQueue);
        this.consumerRunnable = new ConsumerRunnable(this.fileQueue, this);
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        Instant now = Instant.now();
        ZonedDateTime zdt = ZonedDateTime.ofInstant(now, ZoneOffset.UTC);
        String current = this.intervalFormatter.format(zdt);
        this.readLock.lock();
        try {
            long currentLong = Long.parseLong(current);
            if (this.checkState(currentLong)) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    if (this.checkState(currentLong)) {
                        this.process(500);
                        this.closeIo();
                        this.initialization = currentLong;
                        this.logFilePath = this.getFile();
                        this.open();
                    }
                    this.readLock.lock();
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            LOG_CONSUMER_CONTEXT.executeInExecutorService(this.consumerRunnable);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public final void publish(Record logRecord) {
        boolean offValue;
        this.sys = System.currentTimeMillis();
        GLOBAL_COUNTER.incrementAndGet();
        this.counter.incrementAndGet();
        int levelValue = this.logLevel.intValue();
        int recordLevel = logRecord.intValue();
        boolean intValue = recordLevel < levelValue;
        boolean bl = offValue = levelValue == LogLevel.OFF.intValue();
        if (intValue || offValue) {
            return;
        }
        if (this.filter.isLoggable(logRecord)) {
            return;
        }
        LOG_PRODUCER_CONTEXT.executeInExecutorService((Object)logRecord, this.producerWorker);
        int size = this.fileQueue.size();
        if (500 <= size) {
            LOG_PRODUCER_NOTICE_CONSUMER_CONTEXT.executeInExecutorService((Object)this, this.producerNoticeConsumerWorker);
        }
    }

    private boolean checkState(long current) {
        long intervalTemp = current - this.initialization;
        boolean isInterval = intervalTemp >= (long)this.interval;
        return this.rotatable && isInterval;
    }

    private void config() {
        try {
            Class<?> aClass = this.getClass();
            String className = aClass.getName();
            String tempPrefix = this.prefix + className;
            String rotatableStr = this.getProperty(tempPrefix + ".rotatable", "true");
            this.rotatable = Boolean.parseBoolean(rotatableStr);
            this.directory = this.getProperty(tempPrefix + ".directory", "logs");
            this.suffix = this.getProperty(tempPrefix + ".suffix", ".log");
            String intervalStr = this.getProperty(tempPrefix + ".interval", "1");
            this.interval = Integer.parseInt(intervalStr);
            String intervalFormatterStr = this.getProperty(tempPrefix + ".intervalFormatter", "yyyyMMdd");
            this.intervalFormatter = DateTimeFormatter.ofPattern(intervalFormatterStr);
            Instant now = Instant.now();
            ZonedDateTime zdt = ZonedDateTime.ofInstant(now, ZoneOffset.UTC);
            String format = this.intervalFormatter.format(zdt);
            this.initialization = Long.parseLong(format);
            String encodingStr = this.getProperty(tempPrefix + ".encoding", "UTF-8");
            this.setEncoding(encodingStr);
            String logLevelName = LogLevel.ALL.getName();
            String levelStr = this.getProperty(tempPrefix + ".level", logLevelName);
            Level level = LogLevel.findLevel((String)levelStr);
            this.setLevel(level);
            String filterName = this.getProperty(tempPrefix + ".filter", "org.jdklog.logging.core.filter.StudyJuliFilter");
            Constructor<?> filterConstructor = ClassLoadingUtils.constructor(filterName);
            Filter filterTemp = (Filter)ClassLoadingUtils.newInstance(filterConstructor);
            this.setFilter(filterTemp);
            String formatterName = this.getProperty(tempPrefix + ".formatter", "org.jdklog.logging.core.formatter.StudyJuliMessageTextFormatter");
            Constructor<?> formatterConstructor = ClassLoadingUtils.constructor(formatterName);
            Formatter formatterTemp = (Formatter)ClassLoadingUtils.newInstance(formatterConstructor);
            this.setFormatter(formatterTemp);
            this.logFilePath = this.getFile();
        }
        catch (Exception e) {
            throw new StudyJuliRuntimeException((Throwable)e);
        }
    }

    private File getFile() {
        File path = new File(this.directory + File.separator + this.prefix);
        if (!path.exists() && !path.mkdirs()) {
            throw new StudyJuliRuntimeException("\u76ee\u5f55\u521b\u5efa\u5f02\u5e38.");
        }
        String logName = "";
        if (this.rotatable) {
            logName = Long.toString(this.initialization);
        }
        String logFileName = this.prefix + logName + this.suffix;
        return new File(path, logFileName);
    }

    public final void process(int size) {
        try {
            boolean flag = false;
            for (int i = 0; i < size; ++i) {
                Record logRecord = (Record)this.fileQueue.poll();
                if (null == logRecord) continue;
                flag = true;
                String format = this.formatter.format(logRecord);
                this.bufferedWriter.write(format);
            }
            if (flag) {
                this.bufferedWriter.flush();
            }
        }
        catch (Exception e) {
            throw new StudyJuliRuntimeException((Throwable)e);
        }
    }

    private void open() {
        this.writeLock.lock();
        try {
            Path path = this.logFilePath.toPath();
            this.bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
            this.bufferedWriter.write("");
        }
        catch (Exception e) {
            this.closeIo();
            throw new StudyJuliRuntimeException((Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void closeIo() {
        this.writeLock.lock();
        try {
            if (null != this.bufferedWriter) {
                this.bufferedWriter.write("");
                this.bufferedWriter.flush();
                this.bufferedWriter.close();
                this.bufferedWriter = null;
            }
        }
        catch (Exception e) {
            throw new StudyJuliRuntimeException((Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public final StudyQueue<Record> getFileQueue() {
        return this.fileQueue;
    }

    public final int size() {
        return this.fileQueue.size();
    }
}

