/*
 * Decompiled with CFR 0.152.
 */
package org.jdklog.logging.core.handler;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdklog.logging.api.context.WorkerContext;
import org.jdklog.logging.api.handler.Handler;
import org.jdklog.logging.api.manager.LoaderLogInfo;
import org.jdklog.logging.api.worker.StudyWorker;
import org.jdklog.logging.core.handler.GuardianConsumerWorker;
import org.jdklog.logging.core.manager.AbstractLogManager;

public class GuardianConsumerMonitorRunnable
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(GuardianConsumerMonitorRunnable.class.toString());
    private final WorkerContext context;
    private final StudyWorker<Handler> guardianConsumerWorker = new GuardianConsumerWorker();

    public GuardianConsumerMonitorRunnable(WorkerContext context) {
        this.context = context;
    }

    @Override
    public final void run() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Map<ClassLoader, LoaderLogInfo> classLoaderLoggers = AbstractLogManager.getClassLoaderLoggers1();
            LoaderLogInfo info = classLoaderLoggers.get(classLoader);
            Map handlers = info.getHandlers();
            for (Map.Entry entry : handlers.entrySet()) {
                Handler handler = (Handler)entry.getValue();
                this.context.executeInExecutorService((Object)handler, this.guardianConsumerWorker);
            }
        }
        catch (Exception e) {
            String name = GuardianConsumerMonitorRunnable.class.getName();
            LOGGER.logp(Level.SEVERE, name, "run", "\u5b88\u62a4\u6d88\u8d39\u76d1\u542c\u7ebf\u7a0b\u51fa\u73b0\u5f02\u5e38", e);
        }
    }
}

